/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.ColorMaskStack;
import com.gtnewhorizons.angelica.glsm.stacks.DepthStateStack;
import lombok.Generated;
import net.coderbot.iris.gl.blending.ColorMask;

public class DepthColorStorage {
    private static boolean originalDepthEnable;
    private static ColorMask originalColor;
    private static boolean depthColorLocked;

    public static void disableDepthColor() {
        if (!depthColorLocked) {
            ColorMaskStack colorMask = GLStateManager.getColorMask();
            DepthStateStack depthState = GLStateManager.getDepthState();
            originalDepthEnable = depthState.isEnabled();
            originalColor = new ColorMask(colorMask.red, colorMask.green, colorMask.blue, colorMask.alpha);
        }
        depthColorLocked = false;
        GLStateManager.glDepthMask(false);
        GLStateManager.glColorMask(false, false, false, false);
        depthColorLocked = true;
    }

    public static void deferDepthEnable(boolean enabled) {
        originalDepthEnable = enabled;
    }

    public static void deferColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        originalColor = new ColorMask(red, green, blue, alpha);
    }

    public static void unlockDepthColor() {
        if (!depthColorLocked) {
            return;
        }
        depthColorLocked = false;
        GLStateManager.glDepthMask(originalDepthEnable);
        GLStateManager.glColorMask(originalColor.isRedMasked(), originalColor.isGreenMasked(), originalColor.isBlueMasked(), originalColor.isAlphaMasked());
    }

    @Generated
    public static boolean isDepthColorLocked() {
        return depthColorLocked;
    }
}

