/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class IrisGuiSlot
extends GuiSlot {
    protected boolean renderBackground = true;
    boolean scrolling = false;

    protected IrisGuiSlot(Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.field_148163_i = false;
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        if (this.renderBackground) {
            super.drawContainerBackground(tessellator);
        }
    }

    protected int getScrollBarX() {
        return this.width - 6;
    }

    protected void drawSelectionBox(int x, int y, int mouseX, int mouseY) {
        int oldPadding = this.headerPadding;
        this.headerPadding = 2;
        super.drawSelectionBox(x, y, mouseX, mouseY);
        this.headerPadding = oldPadding;
    }

    protected void elementClicked(int index, boolean doubleClick, int mouseX, int mouseY) {
    }

    protected boolean elementClicked(int index, boolean doubleClick, int mouseX, int mouseY, int button) {
        return false;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.func_148125_i()) {
            return false;
        }
        int size = this.getSize();
        int scrollBarX = this.getScrollBarX();
        int rightEdge = scrollBarX + 6;
        int elementLeft = this.width / 2 - this.getListWidth() / 2;
        int elementRight = this.width / 2 + this.getListWidth() / 2;
        int relativeY = mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
        boolean handled = false;
        boolean leftMouseDown = Mouse.isButtonDown((int)0);
        boolean rightMouseDown = Mouse.isButtonDown((int)1);
        if (mouseX <= this.left || mouseX >= this.right || mouseY <= this.top || mouseY >= this.bottom) {
            return handled;
        }
        if (leftMouseDown && mouseX >= scrollBarX && mouseX <= rightEdge) {
            this.scrolling = true;
            this.initialClickY = mouseY;
        } else if (leftMouseDown || rightMouseDown) {
            int index = relativeY / this.slotHeight;
            if (mouseX >= elementLeft && mouseX <= elementRight && index >= 0 && relativeY >= 0 && index < size) {
                boolean doubleCLick = index == this.selectedElement && Minecraft.getSystemTime() - this.lastClicked < 250L;
                handled = this.elementClicked(index, doubleCLick, mouseX, mouseY, mouseButton);
                this.selectedElement = index;
                this.lastClicked = Minecraft.getSystemTime();
            } else if (mouseX >= elementLeft && mouseX <= elementRight && relativeY < 0) {
                this.func_148132_a(mouseX - elementLeft, mouseY - this.top + (int)this.amountScrolled - 4);
            }
        }
        return handled;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.scrolling = false;
        return false;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        int scrollBarX = this.getScrollBarX();
        int rightEdge = scrollBarX + 6;
        int offset = 4;
        if (this.scrolling) {
            this.amountScrolled += (float)mouseY - this.initialClickY;
            this.initialClickY = mouseY;
        } else if (this.mc.currentScreen != null) {
            while (!this.mc.gameSettings.touchscreen && Mouse.next()) {
                int dWheel;
                if (this.mc.currentScreen != null) {
                    this.mc.currentScreen.handleMouseInput();
                }
                if ((dWheel = Mouse.getEventDWheel()) == 0) continue;
                dWheel = dWheel > 0 ? -1 : 1;
                this.amountScrolled += (float)(dWheel * this.slotHeight) / 2.0f;
            }
        }
        this.bindAmountScrolled();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        this.drawContainerBackground(tessellator);
        int elementRight = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
        int relativeY = this.top + 4 - (int)this.amountScrolled;
        if (this.hasListHeader) {
            this.drawListHeader(elementRight, relativeY, tessellator);
        }
        this.drawSelectionBox(elementRight, relativeY, mouseX, mouseY);
        GL11.glDisable((int)2929);
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)0, (int)1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV((double)this.left, (double)(this.top + 4), 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)this.right, (double)(this.top + 4), 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV((double)this.right, (double)(this.bottom - 4), 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)this.left, (double)(this.bottom - 4), 0.0, 0.0, 0.0);
        tessellator.draw();
        int contentOverflow = this.func_148135_f();
        if (contentOverflow > 0) {
            int scrollPos;
            this.registerScrollButtons(7, 8);
            int scrollPosSize = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (scrollPosSize < 32) {
                scrollPosSize = 32;
            }
            if (scrollPosSize > this.bottom - this.top - 8) {
                scrollPosSize = this.bottom - this.top - 8;
            }
            if ((scrollPos = (int)this.amountScrolled * (this.bottom - this.top - scrollPosSize) / contentOverflow + this.top) < this.top) {
                scrollPos = this.top;
            }
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV((double)scrollBarX, (double)this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((double)rightEdge, (double)this.bottom, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((double)rightEdge, (double)this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV((double)scrollBarX, (double)this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0x808080, 255);
            tessellator.addVertexWithUV((double)scrollBarX, (double)(scrollPos + scrollPosSize), 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((double)rightEdge, (double)(scrollPos + scrollPosSize), 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((double)rightEdge, (double)scrollPos, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV((double)scrollBarX, (double)scrollPos, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0xC0C0C0, 255);
            tessellator.addVertexWithUV((double)scrollBarX, (double)(scrollPos + scrollPosSize - 1), 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((double)(rightEdge - 1), (double)(scrollPos + scrollPosSize - 1), 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((double)(rightEdge - 1), (double)scrollPos, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV((double)scrollBarX, (double)scrollPos, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    @Generated
    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    @Generated
    public boolean isRenderBackground() {
        return this.renderBackground;
    }
}

