/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuLinkElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class LinkElementWidget
extends CommentedElementWidget<OptionMenuLinkElement> {
    private static final String ARROW = new String(">");
    private final String targetScreenId;
    private final String label;
    private NavigationController navigation;
    private String trimmedLabel = null;
    private boolean isLabelTrimmed = false;

    public LinkElementWidget(OptionMenuLinkElement element) {
        super(element);
        this.targetScreenId = element.targetScreenId;
        this.label = GuiUtil.translateOrDefault(new String(element.targetScreenId), "screen." + element.targetScreenId, new Object[0]);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.navigation = navigation;
    }

    @Override
    public void drawScreen(int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(x, y, width, height, hovered, false);
        FontRenderer font = Minecraft.getMinecraft().fontRenderer;
        int maxLabelWidth = width - 9;
        if (font.getStringWidth(this.label) > maxLabelWidth) {
            this.isLabelTrimmed = true;
        }
        if (this.trimmedLabel == null) {
            this.trimmedLabel = GuiUtil.shortenText(font, this.label, maxLabelWidth);
        }
        int labelWidth = font.getStringWidth(this.trimmedLabel);
        font.drawStringWithShadow(this.trimmedLabel, x + (int)((double)width * 0.5) - (int)((double)labelWidth * 0.5) - (int)(0.5 * (double)Math.max(labelWidth - (width - 18), 0)), y + 7, 0xFFFFFF);
        font.drawString(ARROW, x + width - 9, y + 7, 0xFFFFFF);
        if (hovered && this.isLabelTrimmed) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(font, this.label, mouseX + 2, mouseY - 16));
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.navigation.open(this.targetScreenId);
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public Optional<String> getCommentTitle() {
        return Optional.of(this.label);
    }

    @Override
    public Optional<String> getCommentBody() {
        String translation = "screen." + this.targetScreenId + ".comment";
        String translated = I18n.format((String)translation, (Object[])new Object[0]);
        return Optional.ofNullable(!translated.equals(translation) ? I18n.format((String)translation, (Object[])new Object[0]) : null);
    }
}

