/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private static final double COS_22_5 = Math.cos(Math.toRadians(22.5));
    private static final double SIN_22_5 = Math.sin(Math.toRadians(22.5));
    private VertexBuffer vertexBuffer;
    private int currentRenderDistance;

    public HorizonRenderer() {
        this.currentRenderDistance = Minecraft.getMinecraft().gameSettings.renderDistanceChunks;
        this.rebuildBuffer();
    }

    private void rebuildBuffer() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        TessellatorManager.startCapturing();
        CapturingTessellator tessellator = (CapturingTessellator)TessellatorManager.get();
        tessellator.startDrawingQuads();
        this.buildHorizon(this.currentRenderDistance * 16, (Tessellator)tessellator);
        this.vertexBuffer = TessellatorManager.stopCapturingToVBO((VertexFormat)DefaultVertexFormat.POSITION);
    }

    private void buildQuad(Tessellator consumer, double x1, double z1, double x2, double z2) {
        consumer.addVertex(x1, -16.0, z1);
        consumer.addVertex(x1, 16.0, z1);
        consumer.addVertex(x2, 16.0, z2);
        consumer.addVertex(x2, -16.0, z2);
    }

    private void buildHalf(Tessellator consumer, double adjacent, double opposite, boolean invert) {
        if (invert) {
            adjacent = -adjacent;
            opposite = -opposite;
        }
        this.buildQuad(consumer, adjacent, -opposite, opposite, -adjacent);
        this.buildQuad(consumer, adjacent, opposite, adjacent, -opposite);
        this.buildQuad(consumer, opposite, adjacent, adjacent, opposite);
        this.buildQuad(consumer, -opposite, adjacent, opposite, adjacent);
    }

    private void buildOctagonalPrism(Tessellator consumer, double adjacent, double opposite) {
        this.buildHalf(consumer, adjacent, opposite, false);
        this.buildHalf(consumer, adjacent, opposite, true);
    }

    private void buildRegularOctagonalPrism(Tessellator consumer, double radius) {
        this.buildOctagonalPrism(consumer, radius * COS_22_5, radius * SIN_22_5);
    }

    private void buildBottomPlane(Tessellator consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.addVertex((double)(x + 64), -16.0, (double)z);
                consumer.addVertex((double)x, -16.0, (double)z);
                consumer.addVertex((double)x, -16.0, (double)(z + 64));
                consumer.addVertex((double)(x + 64), -16.0, (double)(z + 64));
            }
        }
    }

    private void buildTopPlane(Tessellator consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.addVertex((double)(x + 64), 16.0, (double)z);
                consumer.addVertex((double)(x + 64), 16.0, (double)(z + 64));
                consumer.addVertex((double)x, 16.0, (double)(z + 64));
                consumer.addVertex((double)x, 16.0, (double)z);
            }
        }
    }

    private void buildHorizon(int radius, Tessellator consumer) {
        if (radius > 256) {
            radius = 256;
        }
        this.buildRegularOctagonalPrism(consumer, radius);
        this.buildTopPlane(consumer, 384);
        this.buildBottomPlane(consumer, 384);
    }

    public void renderHorizon(FloatBuffer floatBuffer) {
        if (this.currentRenderDistance != Minecraft.getMinecraft().gameSettings.renderDistanceChunks) {
            this.currentRenderDistance = Minecraft.getMinecraft().gameSettings.renderDistanceChunks;
            this.rebuildBuffer();
        }
        this.vertexBuffer.bind();
        GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
        GL11.glEnableClientState((int)32884);
        this.vertexBuffer.draw(floatBuffer);
        GL11.glDisableClientState((int)32884);
        this.vertexBuffer.unbind();
    }

    public void destroy() {
        this.vertexBuffer.close();
    }
}

