/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public enum PBRType {
    NORMAL("_n", 0x7F7FFFFF),
    SPECULAR("_s", 0);

    private static final PBRType[] VALUES;
    private final String suffix;
    private final int defaultValue;

    private PBRType(String suffix, int defaultValue) {
        this.suffix = suffix;
        this.defaultValue = defaultValue;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public ResourceLocation appendToFileLocation(ResourceLocation location) {
        String newPath;
        String domain = location.getResourceDomain();
        String path = location.getResourcePath();
        try {
            URI uri = new URI(null, null, path, null);
            String cleanPath = uri.getPath();
            int extensionIndex = FilenameUtils.indexOfExtension((String)cleanPath);
            newPath = extensionIndex != -1 ? cleanPath.substring(0, extensionIndex) + this.suffix + cleanPath.substring(extensionIndex) : cleanPath + this.suffix;
            URI newUri = new URI(null, null, newPath, null);
            newPath = newUri.getPath();
        }
        catch (URISyntaxException e) {
            String fallback = path.replace(':', '/');
            int extensionIndex = FilenameUtils.indexOfExtension((String)fallback);
            newPath = extensionIndex != -1 ? fallback.substring(0, extensionIndex) + this.suffix + fallback.substring(extensionIndex) : fallback + this.suffix;
        }
        return new ResourceLocation(domain, newPath);
    }

    @Nullable
    public static PBRType fromFileLocation(String location) {
        for (PBRType type : VALUES) {
            if (!location.endsWith(type.getSuffix())) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = PBRType.values();
    }
}

