/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import lombok.Generated;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import org.joml.Vector4f;

public class CapturedRenderingState {
    public static final CapturedRenderingState INSTANCE = new CapturedRenderingState();
    private float tickDelta;
    private int currentRenderedBlockEntity;
    private Runnable blockEntityIdListener = null;
    private int currentRenderedEntity = -1;
    private Runnable entityIdListener = null;
    private final Vector4f currentEntityColor = new Vector4f();
    private Runnable entityColorListener = null;

    private CapturedRenderingState() {
    }

    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public void setCurrentBlockEntity(int entity) {
        this.currentRenderedBlockEntity = entity;
        if (this.blockEntityIdListener != null) {
            this.blockEntityIdListener.run();
        }
    }

    public void setCurrentEntity(int entity) {
        this.currentRenderedEntity = entity;
        if (this.entityIdListener != null) {
            this.entityIdListener.run();
        }
    }

    public void setCurrentEntityColor(float r, float g, float b, float a) {
        this.currentEntityColor.set(r, g, b, a);
        if (this.entityColorListener != null) {
            this.entityColorListener.run();
        }
    }

    public ValueUpdateNotifier getEntityIdNotifier() {
        return listener -> {
            this.entityIdListener = listener;
        };
    }

    public ValueUpdateNotifier getBlockEntityIdNotifier() {
        return listener -> {
            this.blockEntityIdListener = listener;
        };
    }

    public ValueUpdateNotifier getEntityColorNotifier() {
        return listener -> {
            this.entityColorListener = listener;
        };
    }

    @Generated
    public float getTickDelta() {
        return this.tickDelta;
    }

    @Generated
    public int getCurrentRenderedBlockEntity() {
        return this.currentRenderedBlockEntity;
    }

    @Generated
    public int getCurrentRenderedEntity() {
        return this.currentRenderedEntity;
    }

    @Generated
    public Vector4f getCurrentEntityColor() {
        return this.currentEntityColor;
    }
}

