/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.Objects;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;

public final class WorldTimeUniforms {
    private WorldTimeUniforms() {
    }

    public static void addWorldTimeUniforms(UniformHolder uniforms) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "worldTime", WorldTimeUniforms::getWorldDayTime).uniform1i(UniformUpdateFrequency.PER_TICK, "worldDay", WorldTimeUniforms::getWorldDay).uniform1i(UniformUpdateFrequency.PER_TICK, "moonPhase", () -> WorldTimeUniforms.getWorld().getMoonPhase());
    }

    static int getWorldDayTime() {
        WorldClient world = WorldTimeUniforms.getWorld();
        return (int)((AngelicaConfig.useTotalWorldTime ? world.getTotalWorldTime() : world.getWorldTime()) % 24000L);
    }

    private static int getWorldDay() {
        return (int)(WorldTimeUniforms.getWorld().getTotalWorldTime() / 24000L);
    }

    private static WorldClient getWorld() {
        return Objects.requireNonNull(Minecraft.getMinecraft().theWorld);
    }
}

