/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.gui;

import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class SliderClone
extends GuiButton {
    private final Function<Float, String> displayStringFormatter;
    private final Consumer<Float> valueSetter;
    private final Option option;
    private float sliderPercentage;
    public final String tooltipKey;
    public boolean mouseDragging;

    public SliderClone(int x, int y, int width, int height, Option option, float initialValue, Consumer<Float> setter, Function<Float, String> formatter, String tooltipKey) {
        super(0, x, y, width, height, "");
        this.option = option;
        this.sliderPercentage = option.normalize(initialValue);
        this.displayString = formatter.apply(Float.valueOf(initialValue));
        this.valueSetter = setter;
        this.displayStringFormatter = formatter;
        this.tooltipKey = tooltipKey;
    }

    public int getHoverState(boolean mouseOver) {
        return 0;
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            if (this.mouseDragging) {
                this.sliderPercentage = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
                if (this.sliderPercentage < 0.0f) {
                    this.sliderPercentage = 0.0f;
                }
                if (this.sliderPercentage > 1.0f) {
                    this.sliderPercentage = 1.0f;
                }
                float f = this.option.denormalize(this.sliderPercentage);
                this.valueSetter.accept(Float.valueOf(f));
                this.sliderPercentage = this.option.normalize(f);
                this.displayString = this.displayStringFormatter.apply(Float.valueOf(f));
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.xPosition + (int)(this.sliderPercentage * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
            this.drawTexturedModalRect(this.xPosition + (int)(this.sliderPercentage * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (super.mousePressed(mc, mouseX, mouseY)) {
            this.sliderPercentage = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderPercentage < 0.0f) {
                this.sliderPercentage = 0.0f;
            }
            if (this.sliderPercentage > 1.0f) {
                this.sliderPercentage = 1.0f;
            }
            float f = this.option.denormalize(this.sliderPercentage);
            this.valueSetter.accept(Float.valueOf(f));
            this.sliderPercentage = this.option.normalize(f);
            this.displayString = this.displayStringFormatter.apply(Float.valueOf(f));
            this.mouseDragging = true;
            return true;
        }
        return false;
    }

    public void mouseReleased(int mouseX, int mouseY) {
        this.mouseDragging = false;
    }

    public static class Option {
        float min;
        float max;
        float step;

        float denormalize(float alpha) {
            float lerp = this.min * (1.0f - alpha) + this.max * alpha;
            return (float)Math.round(lerp / this.step) * this.step;
        }

        float normalize(float value) {
            return (value - this.min) / (this.max - this.min);
        }

        @Generated
        public Option(float min, float max, float step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }
    }
}

