/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.hudcaching;

import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.compat.holoinventory.HoloInventoryReflectionCompat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.mixins.interfaces.GuiIngameAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.GuiIngameForgeAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.RenderGameOverlayEventAccessor;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import thaumcraft.common.Thaumcraft;
import xaero.common.core.XaeroMinimapCore;

public class HUDCaching {
    private static final Minecraft mc = Minecraft.getMinecraft();
    public static Framebuffer framebuffer;
    private static boolean dirty;
    private static long nextHudRefresh;
    public static boolean renderingCacheOverride;
    public static boolean renderVignetteCaptured;
    public static boolean renderHelmetCaptured;
    public static float renderPortalCapturedTicks;
    public static boolean renderCrosshairsCaptured;
    private static final RenderGameOverlayEvent fakeTextEvent;
    private static final RenderGameOverlayEvent.Post fakePostEvent;
    public static final HUDCaching INSTANCE;

    private HUDCaching() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onJoinWorld(WorldEvent.Load event) {
        if (event.world.isRemote) {
            AngelicaTweaker.LOGGER.info("World loaded - Initializing HUDCaching");
            framebuffer = new Framebuffer(0, 0, true);
            framebuffer.setFramebufferColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public static void renderCachedHud(EntityRenderer renderer, GuiIngame ingame, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (ModStatus.isXaerosMinimapLoaded && ingame instanceof GuiIngameForge) {
            XaeroMinimapCore.beforeIngameGuiRender((float)partialTicks);
        }
        if (!OpenGlHelper.isFramebufferEnabled() || framebuffer == null) {
            ingame.renderGameOverlay(partialTicks, hasScreen, mouseX, mouseY);
            return;
        }
        if (System.currentTimeMillis() > nextHudRefresh) {
            dirty = true;
        }
        if (dirty) {
            dirty = false;
            nextHudRefresh = System.currentTimeMillis() + (long)(1000 / AngelicaConfig.hudCachingFPS);
            HUDCaching.resetFramebuffer(HUDCaching.mc.displayWidth, HUDCaching.mc.displayHeight);
            framebuffer.bindFramebuffer(false);
            renderingCacheOverride = true;
            ingame.renderGameOverlay(partialTicks, hasScreen, mouseX, mouseY);
            renderingCacheOverride = false;
            mc.getFramebuffer().bindFramebuffer(false);
        } else {
            renderer.setupOverlayRendering();
        }
        ScaledResolution resolution = new ScaledResolution(mc, HUDCaching.mc.displayWidth, HUDCaching.mc.displayHeight);
        int width = resolution.getScaledWidth();
        int height = resolution.getScaledHeight();
        GLStateManager.enableBlend();
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GuiIngameAccessor gui = (GuiIngameAccessor)ingame;
        if (renderVignetteCaptured) {
            gui.callRenderVignette(HUDCaching.mc.thePlayer.getBrightness(partialTicks), width, height);
        } else {
            GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        }
        if (ingame instanceof GuiIngameForge) {
            GuiIngameForgeAccessor guiForge = (GuiIngameForgeAccessor)ingame;
            if (renderHelmetCaptured) {
                guiForge.callRenderHelmet(resolution, partialTicks, hasScreen, mouseX, mouseY);
                if (ModStatus.isHoloInventoryLoaded) {
                    HoloInventoryReflectionCompat.setAngelicaOverride(false);
                    ((RenderGameOverlayEventAccessor)fakePostEvent).setPartialTicks(partialTicks);
                    HoloInventoryReflectionCompat.renderEvent((RenderGameOverlayEvent)fakePostEvent);
                }
            }
            if (renderPortalCapturedTicks > 0.0f) {
                guiForge.callRenderPortal(width, height, partialTicks);
            }
            if (renderCrosshairsCaptured) {
                if (ModStatus.isXaerosMinimapLoaded) {
                    GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                }
                guiForge.callRenderCrosshairs(width, height);
            }
            if (ModStatus.isThaumcraftLoaded || ModStatus.isThaumicHorizonsLoaded) {
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setPartialTicks(partialTicks);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setResolution(resolution);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setMouseX(mouseX);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setMouseY(mouseY);
                if (ModStatus.isThaumcraftLoaded) {
                    Thaumcraft.instance.renderEventHandler.renderOverlay(fakeTextEvent);
                }
                if (ModStatus.isThaumicHorizonsLoaded) {
                    ThaumicHorizons.instance.renderEventHandler.renderOverlay(fakeTextEvent);
                }
            }
        } else {
            if (renderHelmetCaptured) {
                gui.callRenderPumpkinBlur(width, height);
            }
            if (renderPortalCapturedTicks > 0.0f) {
                gui.callRenderPortal(renderPortalCapturedTicks, width, height);
            }
        }
        Tessellator tessellator = TessellatorManager.get();
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(1, 771, 1, 771);
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        framebuffer.bindFramebufferTexture();
        HUDCaching.drawTexturedRect(tessellator, (float)resolution.getScaledWidth_double(), (float)resolution.getScaledHeight_double());
        GLStateManager.tryBlendFuncSeparate(1, 771, 1, 0);
        mc.getTextureManager().bindTexture(Gui.icons);
    }

    public static void fixGLStateBeforeRenderingCache() {
        GLStateManager.glDepthMask(true);
        GLStateManager.enableDepthTest();
        GLStateManager.enableAlphaTest();
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GLStateManager.disableBlend();
    }

    private static void resetFramebuffer(int width, int height) {
        if (HUDCaching.framebuffer.framebufferWidth != width || HUDCaching.framebuffer.framebufferHeight != height) {
            framebuffer.createBindFramebuffer(width, height);
            framebuffer.setFramebufferFilter(9728);
        } else {
            framebuffer.framebufferClear();
        }
        OpenGlHelper.func_153171_g((int)36008, (int)HUDCaching.mc.getFramebuffer().framebufferObject);
        OpenGlHelper.func_153171_g((int)36009, (int)HUDCaching.framebuffer.framebufferObject);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)1280, (int)9728);
    }

    private static void drawTexturedRect(Tessellator tessellator, float width, float height) {
        GLStateManager.enableTexture();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, (double)height, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV((double)width, (double)height, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)width, 0.0, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.draw();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static void disableHoloInventory() {
        if (ModStatus.isHoloInventoryLoaded) {
            HoloInventoryReflectionCompat.setAngelicaOverride(true);
        }
    }

    static {
        dirty = true;
        fakeTextEvent = new RenderGameOverlayEvent.Text(new RenderGameOverlayEvent(0.0f, null, 0, 0), null, null);
        fakePostEvent = new RenderGameOverlayEvent.Post(new RenderGameOverlayEvent(0.0f, null, 0, 0), RenderGameOverlayEvent.ElementType.HELMET);
        INSTANCE = new HUDCaching();
    }

    public static class HUDCachingHooks {
        public static boolean shouldReturnEarly() {
            return renderingCacheOverride;
        }
    }
}

