/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.mcpatcherforge.cc.client.particle;

import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.cc.ColorizeEntity;
import com.prupe.mcpatcher.cc.Colorizer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityDropParticleFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityDropParticleFX.class})
public abstract class MixinEntityDropParticleFX
extends EntityFX {
    @Shadow
    private Material materialType;
    @Shadow
    private int bobTimer;

    protected MixinEntityDropParticleFX(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/block/material/Material;)V"}, at={@At(value="RETURN")})
    private void modifyConstructor(World worldIn, double x, double y, double z, Material material, CallbackInfo ci) {
        if (material == Material.water) {
            if (ColorizeBlock.computeWaterColor(false, (int)this.posX, (int)this.posY, (int)this.posZ)) {
                this.particleRed = Colorizer.setColor[0];
                this.particleGreen = Colorizer.setColor[1];
                this.particleBlue = Colorizer.setColor[2];
            } else {
                this.particleRed = 0.2f;
                this.particleGreen = 0.3f;
                this.particleBlue = 1.0f;
            }
        }
    }

    @Overwrite
    public void onUpdate() {
        double d0;
        Material material;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.materialType != Material.water) {
            if (ColorizeEntity.computeLavaDropColor(40 - this.bobTimer)) {
                this.particleRed = Colorizer.setColor[0];
                this.particleGreen = Colorizer.setColor[1];
                this.particleBlue = Colorizer.setColor[2];
            } else {
                this.particleRed = 1.0f;
                this.particleGreen = 16.0f / (float)(40 - this.bobTimer + 16);
                this.particleBlue = 4.0f / (float)(40 - this.bobTimer + 8);
            }
        }
        this.motionY -= (double)this.particleGravity;
        if (this.bobTimer-- > 0) {
            this.motionX *= 0.02;
            this.motionY *= 0.02;
            this.motionZ *= 0.02;
            this.setParticleTextureIndex(113);
        } else {
            this.setParticleTextureIndex(112);
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.setDead();
        }
        if (this.onGround) {
            if (this.materialType == Material.water) {
                this.setDead();
                this.worldObj.spawnParticle("splash", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
            } else {
                this.setParticleTextureIndex(114);
            }
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if (((material = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)).getMaterial()).isLiquid() || material.isSolid()) && this.posY < (d0 = (double)((float)(MathHelper.floor_double((double)this.posY) + 1) - BlockLiquid.getLiquidHeightPercent((int)this.worldObj.getBlockMetadata(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)))))) {
            this.setDead();
        }
    }
}

