/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.models;

import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizon.gtnhlib.client.model.ModelLoader;
import com.gtnewhorizon.gtnhlib.client.model.Variant;
import com.gtnewhorizon.gtnhlib.client.model.json.ModelLocation;
import com.gtnewhorizon.gtnhlib.client.model.template.BlockColoredCube;
import com.gtnewhorizon.gtnhlib.client.model.template.BlockStaticCube;
import com.gtnewhorizon.gtnhlib.client.model.template.Column3Rot;
import com.gtnewhorizon.gtnhlib.client.model.template.Model4Rot;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadProvider;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class VanillaModels {
    private static boolean init = false;
    public static final BlockStaticCube STONE = new BlockStaticCube("stone");
    public static final BlockStaticCube GLASS = new BlockStaticCube("glass");
    public static BlockColoredCube OAK_LEAVES;
    public static BlockColoredCube SPRUCE_LEAVES;
    public static BlockColoredCube BIRCH_LEAVES;
    public static BlockColoredCube JUNGLE_LEAVES;
    public static QuadProvider OLD_LEAF;
    public static BlockColoredCube ACACIA_LEAVES;
    public static BlockColoredCube DARK_OAK_LEAVES;
    public static QuadProvider NEW_LEAF;
    public static Column3Rot OAK_LOG;
    public static Column3Rot SPRUCE_LOG;
    public static Column3Rot BIRCH_LOG;
    public static Column3Rot JUNGLE_LOG;
    public static BlockStaticCube OAK_WOOD;
    public static BlockStaticCube BIRCH_WOOD;
    public static BlockStaticCube SPRUCE_WOOD;
    public static BlockStaticCube JUNGLE_WOOD;
    public static QuadProvider OLD_LOG;
    public static Column3Rot ACACIA_LOG;
    public static Column3Rot DARK_OAK_LOG;
    public static BlockStaticCube ACACIA_WOOD;
    public static BlockStaticCube DARK_OAK_WOOD;
    public static QuadProvider NEW_LOG;
    public static final Variant workbench;
    public static QuadProvider WORKBENCH;
    public static Model4Rot LECTERN;

    public static void init() {
        if (init) {
            throw new RuntimeException("Vanilla models were baked twice!");
        }
        if (AngelicaConfig.injectQPRendering) {
            ACACIA_LEAVES = new BlockColoredCube("leaves_acacia");
            BIRCH_LEAVES = new BlockColoredCube("leaves_birch");
            DARK_OAK_LEAVES = new BlockColoredCube("leaves_big_oak");
            JUNGLE_LEAVES = new BlockColoredCube("leaves_jungle");
            OAK_LEAVES = new BlockColoredCube("leaves_oak");
            SPRUCE_LEAVES = new BlockColoredCube("leaves_spruce");
            ACACIA_LOG = new Column3Rot((ResourceLocation)new ModelLocation("block/acacia_log"));
            BIRCH_LOG = new Column3Rot((ResourceLocation)new ModelLocation("block/birch_log"));
            DARK_OAK_LOG = new Column3Rot((ResourceLocation)new ModelLocation("block/dark_oak_log"));
            JUNGLE_LOG = new Column3Rot((ResourceLocation)new ModelLocation("block/jungle_log"));
            OAK_LOG = new Column3Rot((ResourceLocation)new ModelLocation("block/oak_log"));
            SPRUCE_LOG = new Column3Rot((ResourceLocation)new ModelLocation("block/spruce_log"));
            ACACIA_WOOD = new BlockStaticCube("log_acacia");
            BIRCH_WOOD = new BlockStaticCube("log_birch");
            DARK_OAK_WOOD = new BlockStaticCube("log_big_oak");
            JUNGLE_WOOD = new BlockStaticCube("log_jungle");
            OAK_WOOD = new BlockStaticCube("log_oak");
            SPRUCE_WOOD = new BlockStaticCube("log_spruce");
            ModelLoader.registerModels(VanillaModels::loadModels, (Variant[])new Variant[]{workbench});
        }
        if (AngelicaConfig.enableTestBlocks) {
            LECTERN = new Model4Rot((ResourceLocation)new ModelLocation("block/lectern"));
        }
        init = true;
    }

    public static void loadModels() {
        WORKBENCH = ModelLoader.getModel((Variant)workbench);
    }

    static {
        OLD_LEAF = new QuadProvider(){

            public int getColor(IBlockAccess world, IBlockPos pos, Block block, int meta, Random random) {
                return QuadProvider.getDefaultColor((IBlockAccess)world, (IBlockPos)pos, (Block)block);
            }

            public List<QuadView> getQuads(IBlockAccess world, IBlockPos pos, Block block, int meta, ForgeDirection dir, Random random, int color, Supplier<QuadView> quadPool) {
                BlockColoredCube blockColoredCube;
                switch (meta % 4) {
                    case 0: {
                        blockColoredCube = OAK_LEAVES;
                        break;
                    }
                    case 1: {
                        blockColoredCube = SPRUCE_LEAVES;
                        break;
                    }
                    case 2: {
                        blockColoredCube = BIRCH_LEAVES;
                        break;
                    }
                    case 3: {
                        blockColoredCube = JUNGLE_LEAVES;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + meta);
                    }
                }
                return blockColoredCube.getQuads(world, pos, block, meta, dir, random, color, quadPool);
            }
        };
        NEW_LEAF = new QuadProvider(){

            public int getColor(IBlockAccess world, IBlockPos pos, Block block, int meta, Random random) {
                return QuadProvider.getDefaultColor((IBlockAccess)world, (IBlockPos)pos, (Block)block);
            }

            public List<QuadView> getQuads(IBlockAccess world, IBlockPos pos, Block block, int meta, ForgeDirection dir, Random random, int color, Supplier<QuadView> quadPool) {
                BlockColoredCube blockColoredCube;
                switch (meta % 2) {
                    case 0: {
                        blockColoredCube = ACACIA_LEAVES;
                        break;
                    }
                    case 1: {
                        blockColoredCube = DARK_OAK_LEAVES;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + meta);
                    }
                }
                return blockColoredCube.getQuads(world, pos, block, meta, dir, random, color, quadPool);
            }
        };
        OLD_LOG = new QuadProvider(){

            public List<QuadView> getQuads(IBlockAccess world, IBlockPos pos, Block block, int meta, ForgeDirection dir, Random random, int color, Supplier<QuadView> quadPool) {
                QuadProvider quadProvider;
                Column3Rot column3Rot;
                if (meta > 11) {
                    BlockStaticCube blockStaticCube;
                    switch (meta) {
                        case 12: {
                            blockStaticCube = OAK_WOOD;
                            break;
                        }
                        case 13: {
                            blockStaticCube = SPRUCE_WOOD;
                            break;
                        }
                        case 14: {
                            blockStaticCube = BIRCH_WOOD;
                            break;
                        }
                        case 15: {
                            blockStaticCube = JUNGLE_WOOD;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + meta);
                        }
                    }
                    return blockStaticCube.getQuads(world, pos, block, meta, dir, random, color, quadPool);
                }
                switch (meta % 4) {
                    case 0: {
                        column3Rot = OAK_LOG;
                        break;
                    }
                    case 1: {
                        column3Rot = SPRUCE_LOG;
                        break;
                    }
                    case 2: {
                        column3Rot = BIRCH_LOG;
                        break;
                    }
                    case 3: {
                        column3Rot = JUNGLE_LOG;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + meta);
                    }
                }
                Column3Rot ret = column3Rot;
                switch (meta / 4) {
                    case 0: {
                        quadProvider = ret.updown();
                        break;
                    }
                    case 1: {
                        quadProvider = ret.eastwest();
                        break;
                    }
                    case 2: {
                        quadProvider = ret.northsouth();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + meta);
                    }
                }
                return quadProvider.getQuads(world, pos, block, meta, dir, random, color, quadPool);
            }
        };
        NEW_LOG = new QuadProvider(){

            public List<QuadView> getQuads(IBlockAccess world, IBlockPos pos, Block block, int meta, ForgeDirection dir, Random random, int color, Supplier<QuadView> quadPool) {
                QuadProvider quadProvider;
                Column3Rot column3Rot;
                if (meta > 11) {
                    BlockStaticCube blockStaticCube;
                    switch (meta) {
                        case 12: {
                            blockStaticCube = ACACIA_WOOD;
                            break;
                        }
                        case 13: {
                            blockStaticCube = DARK_OAK_WOOD;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + meta);
                        }
                    }
                    return blockStaticCube.getQuads(world, pos, block, meta, dir, random, color, quadPool);
                }
                switch (meta % 4) {
                    case 0: {
                        column3Rot = ACACIA_LOG;
                        break;
                    }
                    case 1: {
                        column3Rot = DARK_OAK_LOG;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + meta);
                    }
                }
                Column3Rot ret = column3Rot;
                switch (meta / 4) {
                    case 0: {
                        quadProvider = ret.updown();
                        break;
                    }
                    case 1: {
                        quadProvider = ret.eastwest();
                        break;
                    }
                    case 2: {
                        quadProvider = ret.northsouth();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + meta);
                    }
                }
                return quadProvider.getQuads(world, pos, block, meta, dir, random, color, quadPool);
            }
        };
        workbench = new Variant((ResourceLocation)new ModelLocation("block/crafting_table"), 0, 0, true);
    }
}

