/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.item;

import com.prupe.mcpatcher.MCPatcherUtils;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.minecraft.item.Item;

public class ItemAPI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemAPI() {
        File outputFile = new File("items17.txt");
        if (outputFile.isFile()) {
            PrintStream ps = null;
            try {
                ps = new PrintStream(outputFile);
                String[] nameList = new String[32000];
                for (String name17 : GameData.getItemRegistry().getKeys()) {
                    int id;
                    Item item = (Item)GameData.getItemRegistry().getObject(name17);
                    if (item == null || (id = GameData.getItemRegistry().getIDForObject((Object)item)) < 256 || id >= nameList.length) continue;
                    nameList[id] = name17;
                }
                for (int id = 0; id < nameList.length; ++id) {
                    if (nameList[id] == null) continue;
                    ps.printf("canonicalIdByName.put(\"%s\", %d);\n", nameList[id], id);
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(ps);
                    throw throwable;
                }
                MCPatcherUtils.close(ps);
            }
            MCPatcherUtils.close(ps);
        }
    }

    public static Item getFixedItem(String name) {
        Item item = ItemAPI.parseItemName(name);
        if (item == null) {
            throw new IllegalArgumentException("unknown item " + name);
        }
        return item;
    }

    public static Item parseItemName(String name) {
        if (MCPatcherUtils.isNullOrEmpty(name)) {
            return null;
        }
        if (name.matches("\\d+")) {
            int id = Integer.parseInt(name);
            return (Item)GameData.getItemRegistry().getObjectById(id);
        }
        name = ItemAPI.getFullName(name);
        return (Item)GameData.getItemRegistry().getObject(name);
    }

    public static String getItemName(Item item) {
        if (item == null) {
            return "(null)";
        }
        String name = GameData.getItemRegistry().getNameForObject((Object)item);
        return name == null ? String.valueOf(GameData.getItemRegistry().getIDForObject((Object)item)) : name;
    }

    public static String getFullName(String name) {
        return name == null ? null : (name.indexOf(58) >= 0 ? name : "minecraft:" + name);
    }
}

