/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.font;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.client.font.FontProvider;
import com.gtnewhorizons.angelica.client.font.FontProviderMC;
import com.gtnewhorizons.angelica.client.font.FontProviderUnicode;
import com.gtnewhorizons.angelica.client.font.FontStrategist;
import com.gtnewhorizons.angelica.config.FontConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.FontRendererAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Objects;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class BatchingFontRenderer {
    protected FontRenderer underlying;
    protected int[] charWidth = new int[256];
    protected byte[] glyphWidth;
    private int[] colorCode;
    protected final ResourceLocation locationFontTexture;
    private final int AAMode;
    private final int AAStrength;
    private final int texBoundAttrLocation;
    private final int fontShaderId;
    final boolean isSGA;
    final boolean isSplash;
    private int batchDepth = 0;
    private int vtxWriterIndex = 0;
    private int idxWriterIndex = 0;
    private static final int INITIAL_BATCH_SIZE = 256;
    private static final ResourceLocation DUMMY_RESOURCE_LOCATION = new ResourceLocation("angelica$dummy", "this is invalid!");
    private FloatBuffer batchVtxPositions = MemoryUtilities.memAllocFloat((int)512);
    private ByteBuffer batchVtxColors = MemoryUtilities.memAlloc((int)1024);
    private FloatBuffer batchVtxTexCoords = MemoryUtilities.memAllocFloat((int)512);
    private IntBuffer batchIndices = MemoryUtilities.memAllocInt((int)384);
    private FloatBuffer batchVtxTexBounds = MemoryUtilities.memAllocFloat((int)1024);
    private final ObjectArrayList<FontDrawCmd> batchCommands = ObjectArrayList.wrap((Object[])new FontDrawCmd[64], (int)0);
    private final ObjectArrayList<FontDrawCmd> batchCommandPool = ObjectArrayList.wrap((Object[])new FontDrawCmd[64], (int)0);
    private int blendSrcRGB = 770;
    private int blendDstRGB = 771;
    int lastActiveProgram;
    int fontAAModeLast = -1;
    int fontAAStrengthLast = -1;
    private static final char FORMATTING_CHAR = '\u00a7';

    public BatchingFontRenderer(FontRenderer underlying, int[] charWidth, byte[] glyphWidth, int[] colorCode, ResourceLocation locationFontTexture) {
        this.underlying = underlying;
        this.charWidth = charWidth;
        this.glyphWidth = glyphWidth;
        this.colorCode = colorCode;
        this.locationFontTexture = locationFontTexture;
        for (int i = 0; i < 64; ++i) {
            this.batchCommandPool.add((Object)new FontDrawCmd());
        }
        this.isSGA = Objects.equals(this.locationFontTexture.getResourcePath(), "textures/font/ascii_sga.png");
        this.isSplash = FontStrategist.isSplashFontRendererActive(underlying);
        FontProviderMC.get((boolean)this.isSGA).charWidth = this.charWidth;
        FontProviderMC.get((boolean)this.isSGA).locationFontTexture = this.locationFontTexture;
        FontProviderUnicode.get().glyphWidth = this.glyphWidth;
        this.fontShaderId = FontAAShader.getProgram().getProgramId();
        this.AAMode = GL20.glGetUniformLocation((int)this.fontShaderId, (CharSequence)"aaMode");
        this.AAStrength = GL20.glGetUniformLocation((int)this.fontShaderId, (CharSequence)"strength");
        this.texBoundAttrLocation = GL20.glGetAttribLocation((int)this.fontShaderId, (CharSequence)"texBounds");
    }

    private void pushVtx(float x, float y, int rgba, float u, float v, float uMin, float uMax, float vMin, float vMax) {
        int oldCap = this.batchVtxPositions.capacity() / 2;
        if (this.vtxWriterIndex >= oldCap) {
            int newCap = oldCap * 2;
            this.batchVtxPositions = MemoryUtilities.memRealloc((FloatBuffer)this.batchVtxPositions, (int)(newCap * 2));
            this.batchVtxColors = MemoryUtilities.memRealloc((ByteBuffer)this.batchVtxColors, (int)(newCap * 4));
            this.batchVtxTexCoords = MemoryUtilities.memRealloc((FloatBuffer)this.batchVtxTexCoords, (int)(newCap * 2));
            this.batchVtxTexBounds = MemoryUtilities.memRealloc((FloatBuffer)this.batchVtxTexBounds, (int)(newCap * 4));
            int oldIdxCap = this.batchIndices.capacity();
            int newIdxCap = oldIdxCap * 2;
            this.batchIndices = MemoryUtilities.memRealloc((IntBuffer)this.batchIndices, (int)newIdxCap);
        }
        int idx = this.vtxWriterIndex++;
        int idx2 = idx * 2;
        int idx4 = idx * 4;
        this.batchVtxPositions.put(idx2, x);
        this.batchVtxPositions.put(idx2 + 1, y);
        this.batchVtxColors.put(idx4, (byte)(rgba >> 16 & 0xFF));
        this.batchVtxColors.put(idx4 + 1, (byte)(rgba >> 8 & 0xFF));
        this.batchVtxColors.put(idx4 + 2, (byte)(rgba & 0xFF));
        this.batchVtxColors.put(idx4 + 3, (byte)(rgba >> 24 & 0xFF));
        this.batchVtxTexCoords.put(idx2, u);
        this.batchVtxTexCoords.put(idx2 + 1, v);
        this.batchVtxTexBounds.put(idx4, uMin);
        this.batchVtxTexBounds.put(idx4 + 1, uMax);
        this.batchVtxTexBounds.put(idx4 + 2, vMin);
        this.batchVtxTexBounds.put(idx4 + 3, vMax);
    }

    private void pushUntexRect(float x, float y, float w, float h, int rgba) {
        int vtxId = this.vtxWriterIndex;
        this.pushVtx(x, y, rgba, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.pushVtx(x, y + h, rgba, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.pushVtx(x + w, y, rgba, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.pushVtx(x + w, y + h, rgba, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.pushQuadIdx(vtxId);
    }

    private int pushQuadIdx(int startV) {
        int idx = this.idxWriterIndex;
        this.batchIndices.put(idx, startV);
        this.batchIndices.put(idx + 1, startV + 1);
        this.batchIndices.put(idx + 2, startV + 2);
        this.batchIndices.put(idx + 3, startV + 2);
        this.batchIndices.put(idx + 4, startV + 1);
        this.batchIndices.put(idx + 5, startV + 3);
        this.idxWriterIndex += 6;
        return idx;
    }

    private void pushDrawCmd(int startIdx, int idxCount, ResourceLocation texture, boolean isUnicode) {
        if (!this.batchCommands.isEmpty()) {
            FontDrawCmd lastCmd = (FontDrawCmd)this.batchCommands.get(this.batchCommands.size() - 1);
            int prevEndVtx = lastCmd.startVtx + lastCmd.idxCount;
            if (prevEndVtx == startIdx && lastCmd.texture == texture) {
                lastCmd.idxCount += idxCount;
                return;
            }
        }
        if (this.batchCommandPool.isEmpty()) {
            for (int i = 0; i < 64; ++i) {
                this.batchCommandPool.add((Object)new FontDrawCmd());
            }
        }
        FontDrawCmd cmd = (FontDrawCmd)this.batchCommandPool.pop();
        cmd.reset(startIdx, idxCount, texture, isUnicode);
        this.batchCommands.add((Object)cmd);
    }

    public void beginBatch() {
        if (this.batchDepth == Integer.MAX_VALUE) {
            throw new StackOverflowError("More than Integer.MAX_VALUE nested font rendering batch operations");
        }
        ++this.batchDepth;
    }

    public void endBatch() {
        if (this.batchDepth <= 0) {
            this.batchDepth = 0;
            return;
        }
        --this.batchDepth;
        if (this.batchDepth == 0) {
            this.flushBatch();
        }
    }

    private void flushBatch() {
        this.batchCommands.sort(FontDrawCmd.DRAW_ORDER_COMPARATOR);
        boolean isTextureEnabledBefore = GLStateManager.glIsEnabled(3553);
        int boundTextureBefore = GLStateManager.glGetInteger(32873);
        boolean textureChanged = false;
        ResourceLocation lastTexture = DUMMY_RESOURCE_LOCATION;
        GLStateManager.enableTexture();
        GLStateManager.enableAlphaTest();
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(this.blendSrcRGB, this.blendDstRGB, 1, 0);
        GLStateManager.glShadeModel(7424);
        if (FontConfig.fontAAMode != 0) {
            GL20.glVertexAttribPointer((int)this.texBoundAttrLocation, (int)4, (boolean)false, (int)0, (FloatBuffer)this.batchVtxTexBounds);
            GL20.glEnableVertexAttribArray((int)this.texBoundAttrLocation);
            this.lastActiveProgram = GLStateManager.getActiveProgram();
            GLStateManager.glUseProgram(this.fontShaderId);
            if (FontConfig.fontAAMode != this.fontAAModeLast) {
                this.fontAAModeLast = FontConfig.fontAAMode;
                GL20.glUniform1i((int)this.AAMode, (int)FontConfig.fontAAMode);
            }
            if (FontConfig.fontAAStrength != this.fontAAStrengthLast) {
                this.fontAAStrengthLast = FontConfig.fontAAStrength;
                GL20.glUniform1f((int)this.AAStrength, (float)((float)FontConfig.fontAAStrength / 120.0f));
            }
        }
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.batchVtxTexCoords);
        GL11.glEnableClientState((int)32888);
        GL11.glColorPointer((int)4, (int)5121, (int)0, (ByteBuffer)this.batchVtxColors);
        GL11.glEnableClientState((int)32886);
        GL11.glVertexPointer((int)2, (int)0, (FloatBuffer)this.batchVtxPositions);
        GL11.glEnableClientState((int)32884);
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        FontDrawCmd[] cmdsData = (FontDrawCmd[])this.batchCommands.elements();
        int cmdsSize = this.batchCommands.size();
        for (int i = 0; i < cmdsSize; ++i) {
            FontDrawCmd cmd = cmdsData[i];
            if (!Objects.equals(lastTexture, cmd.texture)) {
                if (lastTexture == null) {
                    GLStateManager.glEnable(3553);
                } else if (cmd.texture == null) {
                    GLStateManager.glDisable(3553);
                }
                if (cmd.texture != null) {
                    ((FontRendererAccessor)this.underlying).angelica$bindTexture(cmd.texture);
                    textureChanged = true;
                }
                lastTexture = cmd.texture;
            }
            this.batchIndices.limit(cmd.startVtx + cmd.idxCount);
            this.batchIndices.position(cmd.startVtx);
            GL11.glDrawElements((int)4, (IntBuffer)this.batchIndices);
        }
        if (FontConfig.fontAAMode != 0) {
            GLStateManager.glUseProgram(this.lastActiveProgram);
            GL20.glDisableVertexAttribArray((int)this.texBoundAttrLocation);
        }
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32884);
        if (isTextureEnabledBefore) {
            GLStateManager.glEnable(3553);
        }
        if (textureChanged) {
            GLStateManager.glBindTexture(3553, boundTextureBefore);
        }
        this.batchCommandPool.addAll(this.batchCommands);
        this.batchCommands.clear();
        this.vtxWriterIndex = 0;
        this.idxWriterIndex = 0;
        this.batchIndices.limit(this.batchIndices.capacity());
        this.batchIndices.position(0);
    }

    public static boolean charInRange(char what, char fromInclusive, char toInclusive) {
        return what >= fromInclusive && what <= toInclusive;
    }

    public boolean forceDefaults() {
        return this.isSGA || this.isSplash;
    }

    public float getGlyphScaleX() {
        return this.forceDefaults() ? 1.0f : (float)((double)FontConfig.glyphScale * Math.pow(2.0, FontConfig.glyphAspect)) * (FontStrategist.customFontInUse ? 1.5f : 1.0f);
    }

    public float getGlyphScaleY() {
        return this.forceDefaults() ? 1.0f : (float)((double)FontConfig.glyphScale / Math.pow(2.0, FontConfig.glyphAspect)) * (FontStrategist.customFontInUse ? 1.5f : 1.0f);
    }

    public float getGlyphSpacing() {
        return this.forceDefaults() ? 0.0f : FontConfig.glyphSpacing;
    }

    public float getWhitespaceScale() {
        return this.forceDefaults() ? 1.0f : FontConfig.whitespaceScale;
    }

    public float getShadowOffset() {
        return this.forceDefaults() ? 1.0f : FontConfig.fontShadowOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float drawString(float anchorX, float anchorY, int color, boolean enableShadow, boolean unicodeFlag, CharSequence string, int stringOffset, int stringLength) {
        if (string == null || string.length() == 0) {
            return anchorX + (enableShadow ? 1.0f : 0.0f);
        }
        int shadowColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        FontProviderMC.get((boolean)this.isSGA).charWidth = this.charWidth;
        FontProviderMC.get((boolean)this.isSGA).locationFontTexture = this.locationFontTexture;
        this.beginBatch();
        float curX = anchorX;
        try {
            int ulIdx;
            int totalStringLength = string.length();
            stringOffset = MathHelper.clamp_int((int)stringOffset, (int)0, (int)totalStringLength);
            stringLength = MathHelper.clamp_int((int)stringLength, (int)0, (int)(totalStringLength - stringOffset));
            if (stringLength <= 0) {
                float f = 0.0f;
                return f;
            }
            int stringEnd = stringOffset + stringLength;
            int curColor = color;
            int curShadowColor = shadowColor;
            boolean curItalic = false;
            boolean curRandom = false;
            boolean curBold = false;
            boolean curStrikethrough = false;
            boolean curUnderline = false;
            float glyphScaleY = this.getGlyphScaleY();
            float heightNorth = anchorY + ((float)this.underlying.FONT_HEIGHT - 1.0f) * (0.5f - glyphScaleY / 2.0f);
            float heightSouth = ((float)this.underlying.FONT_HEIGHT - 1.0f) * glyphScaleY;
            float underlineY = heightNorth + ((float)this.underlying.FONT_HEIGHT - 1.0f) * glyphScaleY;
            float underlineStartX = 0.0f;
            float underlineEndX = 0.0f;
            float strikethroughY = heightNorth + ((float)(this.underlying.FONT_HEIGHT / 2) - 1.0f) * glyphScaleY;
            float strikethroughStartX = 0.0f;
            float strikethroughEndX = 0.0f;
            for (int charIdx = stringOffset; charIdx < stringEnd; ++charIdx) {
                char chr = string.charAt(charIdx);
                if (chr == '\u00a7' && charIdx + 1 < stringEnd) {
                    int ulIdx2;
                    char fmtCode = Character.toLowerCase(string.charAt(charIdx + 1));
                    ++charIdx;
                    if (curUnderline && underlineStartX != underlineEndX) {
                        ulIdx2 = this.idxWriterIndex;
                        this.pushUntexRect(underlineStartX, underlineY, underlineEndX - underlineStartX, glyphScaleY, curColor);
                        this.pushDrawCmd(ulIdx2, 6, null, false);
                        underlineStartX = underlineEndX;
                    }
                    if (curStrikethrough && strikethroughStartX != strikethroughEndX) {
                        ulIdx2 = this.idxWriterIndex;
                        this.pushUntexRect(strikethroughStartX, strikethroughY, strikethroughEndX - strikethroughStartX, glyphScaleY, curColor);
                        this.pushDrawCmd(ulIdx2, 6, null, false);
                        strikethroughStartX = strikethroughEndX;
                    }
                    boolean is09 = BatchingFontRenderer.charInRange(fmtCode, '0', '9');
                    boolean isAF = BatchingFontRenderer.charInRange(fmtCode, 'a', 'f');
                    if (is09 || isAF) {
                        curRandom = false;
                        curBold = false;
                        curStrikethrough = false;
                        curUnderline = false;
                        curItalic = false;
                        int colorIdx = is09 ? fmtCode - 48 : fmtCode - 97 + 10;
                        int rgb = this.colorCode[colorIdx];
                        curColor = curColor & 0xFF000000 | rgb & 0xFFFFFF;
                        int shadowRgb = this.colorCode[colorIdx + 16];
                        curShadowColor = curShadowColor & 0xFF000000 | shadowRgb & 0xFFFFFF;
                        continue;
                    }
                    if (fmtCode == 'k') {
                        curRandom = true;
                        continue;
                    }
                    if (fmtCode == 'l') {
                        curBold = true;
                        continue;
                    }
                    if (fmtCode == 'm') {
                        curStrikethrough = true;
                        strikethroughEndX = strikethroughStartX = curX - 1.0f;
                        continue;
                    }
                    if (fmtCode == 'n') {
                        curUnderline = true;
                        underlineEndX = underlineStartX = curX - 1.0f;
                        continue;
                    }
                    if (fmtCode == 'o') {
                        curItalic = true;
                        continue;
                    }
                    if (fmtCode != 'r') continue;
                    curRandom = false;
                    curBold = false;
                    curStrikethrough = false;
                    curUnderline = false;
                    curItalic = false;
                    curColor = color;
                    curShadowColor = shadowColor;
                    continue;
                }
                if (curRandom) {
                    chr = FontProviderMC.get(this.isSGA).getRandomReplacement(chr);
                }
                FontProvider fontProvider = FontStrategist.getFontProvider(this, chr, FontConfig.enableCustomFont, unicodeFlag);
                if (chr == ' ' || chr == '\u00a0' || chr == '\u202f') {
                    curX += 4.0f * this.getWhitespaceScale();
                    continue;
                }
                float uStart = fontProvider.getUStart(chr);
                float vStart = fontProvider.getVStart(chr);
                float xAdvance = fontProvider.getXAdvance(chr) * this.getGlyphScaleX();
                float glyphW = fontProvider.getGlyphW(chr) * this.getGlyphScaleX();
                float uSz = fontProvider.getUSize(chr);
                float vSz = fontProvider.getVSize(chr);
                float itOff = curItalic ? 1.0f : 0.0f;
                float shadowOffset = fontProvider.getShadowOffset();
                ResourceLocation texture = fontProvider.getTexture(chr);
                int vtxId = this.vtxWriterIndex;
                int idxId = this.idxWriterIndex;
                int vtxCount = 0;
                if (enableShadow) {
                    this.pushVtx(curX + itOff + shadowOffset, heightNorth + shadowOffset, curShadowColor, uStart, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushVtx(curX - itOff + shadowOffset, heightNorth + heightSouth + shadowOffset, curShadowColor, uStart, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushVtx(curX + glyphW - 1.0f + itOff + shadowOffset, heightNorth + shadowOffset, curShadowColor, uStart + uSz, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushVtx(curX + glyphW - 1.0f - itOff + shadowOffset, heightNorth + heightSouth + shadowOffset, curShadowColor, uStart + uSz, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushQuadIdx(vtxId + vtxCount);
                    vtxCount += 4;
                    if (curBold) {
                        float shadowOffset2 = 2.0f * shadowOffset;
                        this.pushVtx(curX + itOff + shadowOffset2, heightNorth + shadowOffset, curShadowColor, uStart, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                        this.pushVtx(curX - itOff + shadowOffset2, heightNorth + heightSouth + shadowOffset, curShadowColor, uStart, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                        this.pushVtx(curX + glyphW - 1.0f + itOff + shadowOffset2, heightNorth + shadowOffset, curShadowColor, uStart + uSz, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                        this.pushVtx(curX + glyphW - 1.0f - itOff + shadowOffset2, heightNorth + heightSouth + shadowOffset, curShadowColor, uStart + uSz, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                        this.pushQuadIdx(vtxId + vtxCount);
                        vtxCount += 4;
                    }
                }
                this.pushVtx(curX + itOff, heightNorth, curColor, uStart, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                this.pushVtx(curX - itOff, heightNorth + heightSouth, curColor, uStart, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                this.pushVtx(curX + glyphW - 1.0f + itOff, heightNorth, curColor, uStart + uSz, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                this.pushVtx(curX + glyphW - 1.0f - itOff, heightNorth + heightSouth, curColor, uStart + uSz, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                this.pushQuadIdx(vtxId + vtxCount);
                vtxCount += 4;
                if (curBold) {
                    this.pushVtx(shadowOffset + curX + itOff, heightNorth, curColor, uStart, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushVtx(shadowOffset + curX - itOff, heightNorth + heightSouth, curColor, uStart, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushVtx(shadowOffset + curX + glyphW - 1.0f + itOff, heightNorth, curColor, uStart + uSz, vStart, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushVtx(shadowOffset + curX + glyphW - 1.0f - itOff, heightNorth + heightSouth, curColor, uStart + uSz, vStart + vSz, uStart, uStart + uSz, vStart, vStart + vSz);
                    this.pushQuadIdx(vtxId + vtxCount);
                    vtxCount += 4;
                }
                this.pushDrawCmd(idxId, vtxCount / 2 * 3, texture, chr > '\u00ff');
                underlineEndX = curX += xAdvance + (curBold ? shadowOffset : 0.0f) + this.getGlyphSpacing();
                strikethroughEndX = curX;
            }
            if (curUnderline && underlineStartX != underlineEndX) {
                ulIdx = this.idxWriterIndex;
                this.pushUntexRect(underlineStartX, underlineY, underlineEndX - underlineStartX, glyphScaleY, curColor);
                this.pushDrawCmd(ulIdx, 6, null, false);
            }
            if (curStrikethrough && strikethroughStartX != strikethroughEndX) {
                ulIdx = this.idxWriterIndex;
                this.pushUntexRect(strikethroughStartX, strikethroughY, strikethroughEndX - strikethroughStartX, glyphScaleY, curColor);
                this.pushDrawCmd(ulIdx, 6, null, false);
            }
        }
        finally {
            this.endBatch();
        }
        return curX + (enableShadow ? 1.0f : 0.0f);
    }

    public float getCharWidthFine(char chr) {
        if (chr == '\u00a7') {
            return -1.0f;
        }
        if (chr == ' ' || chr == '\u00a0' || chr == '\u202f') {
            return 4.0f * this.getWhitespaceScale();
        }
        FontProvider fp = FontStrategist.getFontProvider(this, chr, FontConfig.enableCustomFont, this.underlying.getUnicodeFlag());
        return fp.getXAdvance(chr) * this.getGlyphScaleX();
    }

    public void overrideBlendFunc(int srcRgb, int dstRgb) {
        this.blendSrcRGB = srcRgb;
        this.blendDstRGB = dstRgb;
    }

    public void resetBlendFunc() {
        this.blendSrcRGB = 770;
        this.blendDstRGB = 771;
    }

    private static final class FontDrawCmd {
        public int startVtx;
        public int idxCount;
        public boolean isUnicode;
        public ResourceLocation texture;
        public static final Comparator<FontDrawCmd> DRAW_ORDER_COMPARATOR = Comparator.comparing(fdc -> fdc.texture, Comparator.nullsLast(Comparator.comparing(ResourceLocation::getResourceDomain).thenComparing(ResourceLocation::getResourcePath))).thenComparing(fdc -> fdc.startVtx);

        private FontDrawCmd() {
        }

        public void reset(int startVtx, int vtxCount, ResourceLocation texture, boolean isUnicode) {
            this.startVtx = startVtx;
            this.idxCount = vtxCount;
            this.texture = texture;
            this.isUnicode = isUnicode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FontDrawCmd that = (FontDrawCmd)obj;
            return this.startVtx == that.startVtx && this.idxCount == that.idxCount && Objects.equals(this.texture, that.texture);
        }

        public int hashCode() {
            return Objects.hash(this.startVtx, this.idxCount, this.texture);
        }

        public String toString() {
            return "FontDrawCmd[startVtx=" + this.startVtx + ", vtxCount=" + this.idxCount + ", texture=" + this.texture + ']';
        }
    }

    private static class FontAAShader {
        private static Program fontShader = null;

        private FontAAShader() {
        }

        public static Program getProgram() {
            if (fontShader == null) {
                String vsh;
                String fsh;
                try {
                    fsh = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(FontAAShader.class.getResourceAsStream("/assets/angelica/shaders/fontFilter.fsh"))), StandardCharsets.UTF_8);
                    vsh = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(FontAAShader.class.getResourceAsStream("/assets/angelica/shaders/fontFilter.vsh"))), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ProgramBuilder builder = ProgramBuilder.begin("fontFilter", vsh, null, fsh, (ImmutableSet<Integer>)ImmutableSet.of((Object)0));
                fontShader = builder.build();
            }
            return fontShader;
        }
    }
}

