/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.cit.ArmorOverride;
import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.Enchantment;
import com.prupe.mcpatcher.cit.ItemOverride;
import com.prupe.mcpatcher.mal.item.ItemAPI;
import com.prupe.mcpatcher.mal.nbt.NBTRule;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

abstract class OverrideBase
implements Comparable<OverrideBase> {
    static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_ITEM_TEXTURES, "CIT");
    private static final int MAX_DAMAGE = 65535;
    private static final int MAX_STACK_SIZE = 65535;
    final PropertiesFile properties;
    final ResourceLocation textureName;
    final Map<String, ResourceLocation> alternateTextures;
    final int weight;
    final Set<Item> items;
    final BitSet damagePercent;
    final BitSet damage;
    final int damageMask;
    final BitSet stackSize;
    final BitSet enchantmentIDs;
    final BitSet enchantmentLevels;
    private final List<NBTRule> nbtRules = new ArrayList<NBTRule>();
    int lastEnchantmentLevel;

    static OverrideBase create(ResourceLocation filename) {
        OverrideBase override;
        String type;
        if (new File(filename.getResourcePath()).getName().equals("cit.properties")) {
            return null;
        }
        PropertiesFile properties = PropertiesFile.get(logger, filename);
        if (properties == null) {
            return null;
        }
        switch (type = properties.getString("type", "item").toLowerCase()) {
            case "item": {
                if (!CITUtils.enableItems) {
                    return null;
                }
                override = new ItemOverride(properties);
                break;
            }
            case "enchantment": 
            case "overlay": {
                if (!CITUtils.enableEnchantments) {
                    return null;
                }
                override = new Enchantment(properties);
                break;
            }
            case "armor": {
                if (!CITUtils.enableArmor) {
                    return null;
                }
                override = new ArmorOverride(properties);
                break;
            }
            default: {
                logger.error("%s: unknown type '%s'", filename, type);
                return null;
            }
        }
        return override.properties.valid() ? override : null;
    }

    OverrideBase(PropertiesFile properties) {
        this.properties = properties;
        this.alternateTextures = this.getAlternateTextures();
        String value = properties.getString("source", "");
        ResourceLocation resource = null;
        if (value.isEmpty()) {
            value = properties.getString("texture", "");
        }
        if (value.isEmpty()) {
            value = properties.getString("tile", "");
        }
        if (value.isEmpty()) {
            if (MCPatcherUtils.isNullOrEmpty(this.alternateTextures) && !TexturePackAPI.hasResource(resource = TileLoader.getDefaultAddress(properties.getResource()))) {
                resource = null;
            }
        } else {
            resource = TileLoader.parseTileAddress(properties.getResource(), value);
            if (!TexturePackAPI.hasResource(resource)) {
                properties.error("source texture %s not found", value);
                resource = null;
            }
        }
        this.textureName = resource;
        this.weight = properties.getInt("weight", 0);
        value = properties.getString("items", "");
        if (value.isEmpty()) {
            value = properties.getString("matchItems", "");
        }
        if (value.isEmpty()) {
            this.items = null;
        } else {
            this.items = new HashSet<Item>();
            for (String s : value.split("\\s+")) {
                Item item = ItemAPI.parseItemName(s);
                if (item == null) continue;
                this.items.add(item);
            }
        }
        value = properties.getString("damage", "");
        if (value.isEmpty()) {
            this.damage = null;
            this.damagePercent = null;
        } else if (value.contains("%")) {
            this.damage = null;
            this.damagePercent = OverrideBase.parseBitSet(value.replace("%", ""), 0, 100);
        } else {
            this.damage = OverrideBase.parseBitSet(value, 0, 65535);
            this.damagePercent = null;
        }
        this.damageMask = properties.getInt("damageMask", 65535);
        this.stackSize = OverrideBase.parseBitSet(properties, "stackSize", 0, 65535);
        this.enchantmentIDs = OverrideBase.parseBitSet(properties, "enchantmentIDs", 0, 255);
        this.enchantmentLevels = OverrideBase.parseBitSet(properties, "enchantmentLevels", 0, 255);
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith("nbt.")) continue;
            value = (String)entry.getValue();
            NBTRule rule = NBTRule.create(name, value);
            if (rule == null) {
                properties.error("invalid nbt rule: %s", value);
                continue;
            }
            this.nbtRules.add(rule);
        }
    }

    @Override
    public int compareTo(OverrideBase o) {
        int result = o.weight - this.weight;
        if (result != 0) {
            return result;
        }
        return this.properties.getResource().toString().compareTo(o.properties.getResource().toString());
    }

    boolean match(ItemStack itemStack, int[] itemEnchantmentLevels, boolean hasEffect) {
        return this.matchDamage(itemStack) && this.matchDamagePercent(itemStack) && this.matchStackSize(itemStack) && this.matchEnchantment(itemEnchantmentLevels, hasEffect) && this.matchNBT(itemStack);
    }

    String preprocessAltTextureKey(String name) {
        return name;
    }

    private Map<String, ResourceLocation> getAlternateTextures() {
        HashMap<String, ResourceLocation> tmpMap = new HashMap<String, ResourceLocation>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            ResourceLocation resource;
            String name;
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("source.")) {
                name = key.substring(7);
            } else if (key.startsWith("texture.")) {
                name = key.substring(8);
            } else {
                if (!key.startsWith("tile.")) continue;
                name = key.substring(5);
            }
            if (MCPatcherUtils.isNullOrEmpty(name = this.preprocessAltTextureKey(name)) || (resource = TileLoader.parseTileAddress(this.properties.getResource(), value)) == null) continue;
            tmpMap.put(name, resource);
        }
        return tmpMap.isEmpty() ? null : tmpMap;
    }

    private boolean matchDamage(ItemStack itemStack) {
        return this.damage == null || this.damage.get(itemStack.getItemDamage() & this.damageMask);
    }

    private boolean matchDamagePercent(ItemStack itemStack) {
        if (this.damagePercent == null) {
            return true;
        }
        int maxDamage = itemStack.getMaxDamage();
        if (maxDamage == 0) {
            return false;
        }
        int percent = 100 * itemStack.getItemDamage() / maxDamage;
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        return this.damagePercent.get(percent);
    }

    private boolean matchStackSize(ItemStack itemStack) {
        return this.stackSize == null || this.stackSize.get(itemStack.stackSize);
    }

    private boolean matchEnchantment(int[] itemEnchantmentLevels, boolean hasEffect) {
        if (this.enchantmentLevels == null && this.enchantmentIDs == null) {
            return true;
        }
        if (itemEnchantmentLevels == null) {
            this.lastEnchantmentLevel = this.getEnchantmentLevelMatch(hasEffect);
            return this.lastEnchantmentLevel >= 0;
        }
        this.lastEnchantmentLevel = this.getEnchantmentLevelMatch(itemEnchantmentLevels);
        return this.lastEnchantmentLevel >= 0;
    }

    private int getEnchantmentLevelMatch(boolean hasEffect) {
        if (hasEffect && this.enchantmentIDs == null && this.enchantmentLevels.get(1)) {
            return 1;
        }
        return -1;
    }

    private int getEnchantmentLevelMatch(int[] itemEnchantmentLevels) {
        int matchLevel = -1;
        if (this.enchantmentIDs == null) {
            int sum = 0;
            for (int level : itemEnchantmentLevels) {
                sum += level;
            }
            if (this.enchantmentLevels.get(sum)) {
                return sum;
            }
        } else if (this.enchantmentLevels == null) {
            int id = this.enchantmentIDs.nextSetBit(0);
            while (id >= 0) {
                if (itemEnchantmentLevels[id] > 0) {
                    matchLevel = Math.max(matchLevel, itemEnchantmentLevels[id]);
                }
                id = this.enchantmentIDs.nextSetBit(id + 1);
            }
        } else {
            int id = this.enchantmentIDs.nextSetBit(0);
            while (id >= 0) {
                if (this.enchantmentLevels.get(itemEnchantmentLevels[id])) {
                    matchLevel = Math.max(matchLevel, itemEnchantmentLevels[id]);
                }
                id = this.enchantmentIDs.nextSetBit(id + 1);
            }
        }
        return matchLevel;
    }

    private boolean matchNBT(ItemStack itemStack) {
        for (NBTRule rule : this.nbtRules) {
            if (rule.match(itemStack.getTagCompound())) continue;
            return false;
        }
        return true;
    }

    abstract String getType();

    public String toString() {
        return String.format("ItemOverride{%s, %s, %s}", this.getType(), this.properties, this.textureName);
    }

    private static BitSet parseBitSet(PropertiesFile properties, String tag, int min, int max) {
        String value = properties.getString(tag, "");
        return OverrideBase.parseBitSet(value, min, max);
    }

    private static BitSet parseBitSet(String value, int min, int max) {
        if (value.isEmpty()) {
            return null;
        }
        BitSet bits = new BitSet();
        for (int i : MCPatcherUtils.parseIntegerList(value, min, max)) {
            bits.set(i);
        }
        return bits;
    }
}

