/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import com.falsepattern.endlessids.mixin.helpers.ChunkBiomeHook;
import com.gtnewhorizons.angelica.compat.ExtendedBlockStorageExt;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.compat.mojang.ChunkSectionPos;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import mega.fluidlogged.internal.mixin.hook.FLSubChunk;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fluids.Fluid;

public class ClonedChunkSection {
    private static final ExtendedBlockStorage EMPTY_SECTION = new ExtendedBlockStorage(0, false);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final ClonedChunkSectionCache backingCache;
    private final Short2ObjectMap<TileEntity> tileEntities;
    private ExtendedBlockStorageExt data;
    private final World world;
    private ChunkSectionPos pos;
    private BiomeGenBase[] biomeData;
    private long lastUsedTimestamp = Long.MAX_VALUE;

    ClonedChunkSection(ClonedChunkSectionCache backingCache, World world) {
        this.backingCache = backingCache;
        this.world = world;
        this.tileEntities = new Short2ObjectOpenHashMap();
    }

    public void init(ChunkSectionPos pos) {
        Chunk chunk = this.world.getChunkFromChunkCoords(pos.x, pos.z);
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + pos.toChunkPos());
        }
        ExtendedBlockStorage section = ClonedChunkSection.getChunkSection(chunk, pos);
        if (section == null) {
            section = EMPTY_SECTION;
        }
        this.pos = pos;
        this.data = new ExtendedBlockStorageExt(chunk, section);
        int bArrLength = ModStatus.isEIDBiomeLoaded ? ((ChunkBiomeHook)chunk).getBiomeShortArray().length : chunk.getBiomeArray().length;
        this.biomeData = new BiomeGenBase[bArrLength];
        this.tileEntities.clear();
        for (int y = pos.getMinY(); y <= pos.getMaxY(); ++y) {
            for (int z = pos.getMinZ(); z <= pos.getMaxZ(); ++z) {
                for (int x = pos.getMinX(); x <= pos.getMaxX(); ++x) {
                    TileEntity tileentity;
                    int lX = x & 0xF;
                    int lY = y & 0xF;
                    int lZ = z & 0xF;
                    Block block = this.data.getBlockByExtId(lX, lY, lZ);
                    if (!block.hasTileEntity(this.data.getExtBlockMetadata(lX, lY, lZ)) || (tileentity = chunk.func_150806_e(x & 0xF, y, z & 0xF)) == null) continue;
                    this.tileEntities.put(ChunkSectionPos.packLocal(tileentity.xCoord & 0xF, tileentity.yCoord & 0xF, tileentity.zCoord & 0xF), (Object)tileentity);
                }
            }
        }
        for (int z = pos.getMinZ(); z <= pos.getMaxZ(); ++z) {
            for (int x = pos.getMinX(); x <= pos.getMaxX(); ++x) {
                this.biomeData[(z & 0xF) << 4 | x & 0xF] = this.world.getBiomeGenForCoords(x, z);
            }
        }
    }

    public Block getBlock(int x, int y, int z) {
        return this.data.getBlockByExtId(x, y, z);
    }

    public Fluid getFluid(int x, int y, int z) {
        if (ModStatus.isFluidLoggedLoaded) {
            return ((FLSubChunk)this.data).fl$getFluid(x, y, z);
        }
        return null;
    }

    public int getBlockMetadata(int x, int y, int z) {
        return this.data.getExtBlockMetadata(x, y, z);
    }

    public NibbleArray getLightArray(EnumSkyBlock type) {
        if (type == EnumSkyBlock.Sky) {
            return !this.world.provider.hasNoSky && this.data.hasSky ? this.data.getSkylightArray() : null;
        }
        return this.data.getBlocklightArray();
    }

    public BiomeGenBase getBiomeForNoiseGen(int x, int y, int z) {
        return this.biomeData[x | z << 4];
    }

    public TileEntity getBlockEntity(int x, int y, int z) {
        return (TileEntity)this.tileEntities.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public ChunkSectionPos getPosition() {
        return this.pos;
    }

    public static boolean isOutOfBuildLimitVertically(int y) {
        return y < 0 || y >= 256;
    }

    private static ExtendedBlockStorage getChunkSection(Chunk chunk, ChunkSectionPos pos) {
        if (!ClonedChunkSection.isOutOfBuildLimitVertically(ChunkSectionPos.getBlockCoord(pos.y()))) {
            return chunk.getBlockStorageArray()[pos.y];
        }
        return null;
    }

    public void acquireReference() {
        this.referenceCount.incrementAndGet();
    }

    public boolean releaseReference() {
        return this.referenceCount.decrementAndGet() <= 0;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }

    private static short packLocal(int x, int y, int z) {
        return (short)(x << 8 | z << 4 | y);
    }

    @Generated
    public BiomeGenBase[] getBiomeData() {
        return this.biomeData;
    }
}

