/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.opengl.GL11;

public class CustomTextureManager {
    private final EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> customTextureIdMap = new EnumMap(TextureStage.class);
    private final IntSupplier noise;
    private final List<AbstractTexture> ownedTextures = new ArrayList<AbstractTexture>();

    public CustomTextureManager(PackDirectives packDirectives, EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap, Optional<CustomTextureData> customNoiseTextureData) {
        customTextureDataMap.forEach((textureStage, customTextureStageDataMap) -> {
            Object2ObjectOpenHashMap customTextureIds = new Object2ObjectOpenHashMap();
            customTextureStageDataMap.forEach((arg_0, arg_1) -> this.lambda$new$0((Object2ObjectMap)customTextureIds, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, IntSupplier>)customTextureIds);
        });
        this.noise = customNoiseTextureData.flatMap(textureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)textureData));
            }
            catch (IOException e) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", e);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int noiseTextureResolution = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture texture = new NativeImageBackedNoiseTexture(noiseTextureResolution);
            this.ownedTextures.add((AbstractTexture)texture);
            return () -> ((AbstractTexture)texture).getGlTextureId();
        });
    }

    private IntSupplier createCustomTexture(CustomTextureData textureData) throws IOException {
        if (textureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture texture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)textureData);
            this.ownedTextures.add((AbstractTexture)texture);
            return () -> ((AbstractTexture)texture).getGlTextureId();
        }
        if (textureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)textureData;
            String namespace = resourceData.getNamespace();
            String location = resourceData.getLocation();
            int extensionIndex = FilenameUtils.indexOfExtension((String)location);
            String withoutExtension = extensionIndex != -1 ? location.substring(0, extensionIndex) : location;
            PBRType pbrType = PBRType.fromFileLocation(withoutExtension);
            TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
            if (pbrType == null) {
                ResourceLocation textureLocation = new ResourceLocation(namespace, location);
                return () -> {
                    ITextureObject texture = textureManager.getTexture(textureLocation);
                    return texture != null ? texture.getGlTextureId() : TextureUtil.missingTexture.getGlTextureId();
                };
            }
            location = location.substring(0, extensionIndex - pbrType.getSuffix().length()) + location.substring(extensionIndex);
            ResourceLocation textureLocation = new ResourceLocation(namespace, location);
            return () -> {
                ITextureObject texture = textureManager.getTexture(textureLocation);
                if (texture != null) {
                    AbstractTexture abstractTexture;
                    int id = texture.getGlTextureId();
                    PBRTextureHolder pbrHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(id);
                    switch (pbrType) {
                        case NORMAL: {
                            abstractTexture = pbrHolder.getNormalTexture();
                            break;
                        }
                        case SPECULAR: {
                            abstractTexture = pbrHolder.getSpecularTexture();
                            break;
                        }
                        default: {
                            throw new Error("Unknown PBRType '" + (Object)((Object)pbrType) + "'");
                        }
                    }
                    AbstractTexture pbrTexture = abstractTexture;
                    TextureFormat textureFormat = TextureFormatLoader.getFormat();
                    if (textureFormat != null) {
                        int previousBinding = GL11.glGetInteger((int)32873);
                        GLStateManager.glBindTexture(3553, pbrTexture.getGlTextureId());
                        textureFormat.setupTextureParameters(pbrType, pbrTexture);
                        GLStateManager.glBindTexture(3553, previousBinding);
                    }
                    return pbrTexture.getGlTextureId();
                }
                return TextureUtil.missingTexture.getGlTextureId();
            };
        }
        throw new IllegalArgumentException("Unable to handle custom texture data " + textureData);
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    public Object2ObjectMap<String, IntSupplier> getCustomTextureIdMap(TextureStage stage) {
        return this.customTextureIdMap.getOrDefault((Object)stage, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap());
    }

    public IntSupplier getNoiseTexture() {
        return this.noise;
    }

    public void destroy() {
    }

    private /* synthetic */ void lambda$new$0(Object2ObjectMap customTextureIds, TextureStage textureStage, String samplerName, CustomTextureData textureData) {
        try {
            customTextureIds.put((Object)samplerName, (Object)this.createCustomTexture(textureData));
        }
        catch (IOException e) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + (Object)((Object)textureStage) + ", sampler " + samplerName, e);
        }
    }
}

