/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.fml.tweakers;

import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.mixin.transformer.Config;

public class IncompatibleModsDisablerTweaker
implements ITweaker {
    private static final boolean DISABLE_OPTIFINE_FASTCRAFT_BETTERFPS = true;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        FMLRelaunchLog.info((String)"[Angelica/IncompatibleModsDisablerTweaker] Disabling Optifine, Fastcraft, BetterFPS, and other incompatible mods (if present)", (Object[])new Object[0]);
        this.disableIncompatibleMods(classLoader);
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    private void disableIncompatibleMods(LaunchClassLoader lcl) {
        try {
            Field xformersField = lcl.getClass().getDeclaredField("transformers");
            xformersField.setAccessible(true);
            List xformers = (List)xformersField.get(lcl);
            for (int idx = xformers.size() - 1; idx >= 0; --idx) {
                String name = ((IClassTransformer)xformers.get(idx)).getClass().getName();
                if (!name.startsWith("optifine") && !name.startsWith("fastcraft") && !name.startsWith("me.guichaguri.betterfps")) continue;
                FMLRelaunchLog.info((String)("[Angelica/IncompatibleModsDisablerTweaker] Removing transformer " + name), (Object[])new Object[0]);
                xformers.remove(idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Class<?> loaderClass = Class.forName("cpw.mods.fml.common.Loader", true, (ClassLoader)lcl);
            Field injectedContainersField = loaderClass.getDeclaredField("injectedContainers");
            injectedContainersField.setAccessible(true);
            List containers = (List)injectedContainersField.get(loaderClass);
            for (int idx = containers.size() - 1; idx >= 0; --idx) {
                String name = (String)containers.get(idx);
                if (!name.startsWith("optifine") && !name.startsWith("fastcraft")) continue;
                FMLRelaunchLog.info((String)("[Angelica/IncompatibleModsDisablerTweaker] Removing mod container " + name), (Object[])new Object[0]);
                containers.remove(idx);
            }
            Field reparsedCoremodsField = CoreModManager.class.getDeclaredField("reparsedCoremods");
            Field loadedCoremodsField = CoreModManager.class.getDeclaredField("loadedCoremods");
            reparsedCoremodsField.setAccessible(true);
            loadedCoremodsField.setAccessible(true);
            ArrayList reparsedCoremods = (ArrayList)reparsedCoremodsField.get(CoreModManager.class);
            ArrayList loadedCoremods = (ArrayList)loadedCoremodsField.get(CoreModManager.class);
            for (int idx = reparsedCoremods.size() - 1; idx >= 0; --idx) {
                String coreMod = (String)reparsedCoremods.get(idx);
                if (!coreMod.startsWith("optimizationsandtweaks")) continue;
                FMLRelaunchLog.info((String)("[Angelica/IncompatibleModsDisablerTweaker] Removing reparsed coremod " + coreMod), (Object[])new Object[0]);
                loadedCoremods.add((String)reparsedCoremods.remove(idx));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            MixinPlatformManager platformManager;
            ArrayList mixinConfigsDefault = (ArrayList)Launch.blackboard.get("mixin.configs.default");
            if (mixinConfigsDefault != null) {
                for (int idx = mixinConfigsDefault.size() - 1; idx >= 0; --idx) {
                    String name = (String)mixinConfigsDefault.get(idx);
                    if (name == null || !name.contains("optimizationsandtweaks")) continue;
                    FMLRelaunchLog.info((String)("[Angelica/IncompatibleModsDisablerTweaker] Removing mixin config " + name), (Object[])new Object[0]);
                    mixinConfigsDefault.remove(idx);
                }
            }
            Set mixinConfigs = (Set)Launch.blackboard.get("mixin.configs.queue");
            HashSet<Config> toRemove = new HashSet<Config>();
            if (mixinConfigs != null) {
                for (Config config : mixinConfigs) {
                    String name = config.getName();
                    if (name == null || !name.contains("optimizationsandtweaks")) continue;
                    FMLRelaunchLog.info((String)("[Angelica/IncompatibleModsDisablerTweaker] Removing queued mixin config " + config.getName()), (Object[])new Object[0]);
                    toRemove.add(config);
                }
                mixinConfigs.removeAll(toRemove);
            }
            if ((platformManager = (MixinPlatformManager)Launch.blackboard.get("mixin.platform")) != null) {
                Field containersField = platformManager.getClass().getDeclaredField("containers");
                containersField.setAccessible(true);
                Map containers = (Map)containersField.get(platformManager);
                for (Map.Entry entry : containers.entrySet()) {
                    String attribute = ((IContainerHandle)entry.getKey()).getAttribute("MixinConfigs");
                    if (attribute == null || !attribute.contains("optimizationsandtweaks")) continue;
                    FMLRelaunchLog.info((String)("[Angelica/IncompatibleModsDisablerTweaker] Removing mixin container " + ((IContainerHandle)entry.getKey()).toString()), (Object[])new Object[0]);
                    containers.remove(entry.getKey());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

