/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

final class ItemOverride
extends OverrideBase {
    private IIcon icon;
    private final Map<IIcon, IIcon> iconMap;

    ItemOverride(PropertiesFile properties) {
        super(properties);
        if (this.items == null) {
            properties.error("no matching items specified", new Object[0]);
        }
        this.iconMap = this.alternateTextures == null ? null : new HashMap();
    }

    @Override
    String getType() {
        return "item";
    }

    IIcon getReplacementIcon(IIcon origIcon) {
        IIcon newIcon;
        if (this.iconMap != null && (newIcon = this.iconMap.get(origIcon)) != null) {
            return newIcon;
        }
        return this.icon;
    }

    void preload(TileLoader tileLoader) {
        String special = null;
        if (this.items != null) {
            if (this.items.contains(CITUtils.itemCompass)) {
                special = "compass";
            } else if (this.items.contains(CITUtils.itemClock)) {
                special = "clock";
            }
        }
        if (this.textureName != null) {
            tileLoader.preloadTile(this.textureName, false, special);
        }
        if (this.alternateTextures != null) {
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                tileLoader.preloadTile((ResourceLocation)entry.getValue(), false, special);
            }
        }
    }

    void registerIcon(TileLoader tileLoader) {
        if (this.textureName != null) {
            this.icon = tileLoader.getIcon(this.textureName);
        }
        if (this.alternateTextures != null) {
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                IIcon from = tileLoader.getIcon((String)entry.getKey());
                IIcon to = tileLoader.getIcon((ResourceLocation)entry.getValue());
                if (from == null || to == null) continue;
                this.iconMap.put(from, to);
            }
        }
    }

    @Override
    String preprocessAltTextureKey(String name) {
        if (name.startsWith("textures/items/") && (name = name.substring(15)).endsWith(".png")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }
}

