/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import org.jetbrains.annotations.Nullable;

public enum DepthBufferFormat {
    DEPTH(false),
    DEPTH16(false),
    DEPTH24(false),
    DEPTH32(false),
    DEPTH32F(false),
    DEPTH_STENCIL(true),
    DEPTH24_STENCIL8(true),
    DEPTH32F_STENCIL8(true);

    private final boolean combinedStencil;

    private DepthBufferFormat(boolean combinedStencil) {
        this.combinedStencil = combinedStencil;
    }

    @Nullable
    public static DepthBufferFormat fromGlEnum(int glenum) {
        DepthBufferFormat depthBufferFormat;
        switch (glenum) {
            case 6402: {
                depthBufferFormat = DEPTH;
                break;
            }
            case 33189: {
                depthBufferFormat = DEPTH16;
                break;
            }
            case 33190: {
                depthBufferFormat = DEPTH24;
                break;
            }
            case 33191: {
                depthBufferFormat = DEPTH32;
                break;
            }
            case 36012: {
                depthBufferFormat = DEPTH32F;
                break;
            }
            case 34041: {
                depthBufferFormat = DEPTH_STENCIL;
                break;
            }
            case 35056: {
                depthBufferFormat = DEPTH24_STENCIL8;
                break;
            }
            case 36013: {
                depthBufferFormat = DEPTH32F_STENCIL8;
                break;
            }
            default: {
                depthBufferFormat = null;
            }
        }
        return depthBufferFormat;
    }

    public static DepthBufferFormat fromGlEnumOrDefault(int glenum) {
        DepthBufferFormat format = DepthBufferFormat.fromGlEnum(glenum);
        if (format == null) {
            return DEPTH;
        }
        return format;
    }

    public int getGlInternalFormat() {
        int n;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEPTH: {
                n = 6402;
                break;
            }
            case DEPTH16: {
                n = 33189;
                break;
            }
            case DEPTH24: {
                n = 33190;
                break;
            }
            case DEPTH32: {
                n = 33191;
                break;
            }
            case DEPTH32F: {
                n = 36012;
                break;
            }
            case DEPTH_STENCIL: {
                n = 34041;
                break;
            }
            case DEPTH24_STENCIL8: {
                n = 35056;
                break;
            }
            case DEPTH32F_STENCIL8: {
                n = 36013;
            }
        }
        return n;
    }

    public int getGlType() {
        return this.isCombinedStencil() ? 34041 : 6402;
    }

    public int getGlFormat() {
        int n;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEPTH: 
            case DEPTH16: {
                n = 5123;
                break;
            }
            case DEPTH24: 
            case DEPTH32: {
                n = 5125;
                break;
            }
            case DEPTH32F: {
                n = 5126;
                break;
            }
            case DEPTH_STENCIL: 
            case DEPTH24_STENCIL8: {
                n = 34042;
                break;
            }
            case DEPTH32F_STENCIL8: {
                n = 36269;
            }
        }
        return n;
    }

    public boolean isCombinedStencil() {
        return this.combinedStencil;
    }
}

