/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.BlendStateStack;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfo;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfoCache;
import com.gtnewhorizons.angelica.glsm.texture.TextureTracker;
import com.gtnewhorizons.angelica.mixins.interfaces.EntityRendererAccessor;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.ExternallyManagedUniforms;
import net.coderbot.iris.uniforms.FogUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.HardcodedCustomUniforms;
import net.coderbot.iris.uniforms.IdMapUniforms;
import net.coderbot.iris.uniforms.IrisExclusiveUniforms;
import net.coderbot.iris.uniforms.MatrixUniforms;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.uniforms.ViewportUniforms;
import net.coderbot.iris.uniforms.WorldTimeUniforms;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.uniforms.transforms.SmoothedVec2f;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector4i;

public final class CommonUniforms {
    private static final Minecraft client = Minecraft.func_71410_x();
    private static final Vector2i ZERO_VECTOR_2i = new Vector2i();
    private static final Vector4i ZERO_VECTOR_4i = new Vector4i(0, 0, 0, 0);
    private static final Vector3d ZERO_VECTOR_3d = new Vector3d();

    private CommonUniforms() {
    }

    public static void addNonDynamicUniforms(UniformHolder uniforms, IdMap idMap, PackDirectives directives, FrameUpdateNotifier updateNotifier) {
        CameraUniforms.addCameraUniforms(uniforms, updateNotifier);
        ViewportUniforms.addViewportUniforms(uniforms);
        WorldTimeUniforms.addWorldTimeUniforms(uniforms);
        SystemTimeUniforms.addSystemTimeUniforms(uniforms);
        new CelestialUniforms(directives.getSunPathRotation()).addCelestialUniforms(uniforms);
        IrisExclusiveUniforms.addIrisExclusiveUniforms(uniforms);
        IdMapUniforms.addIdMapUniforms(updateNotifier, uniforms, idMap, directives.isOldHandLight());
        MatrixUniforms.addMatrixUniforms(uniforms, directives);
        if (AngelicaConfig.enableHardcodedCustomUniforms) {
            HardcodedCustomUniforms.addHardcodedCustomUniforms(uniforms, updateNotifier);
        }
        CommonUniforms.generalCommonUniforms(uniforms, updateNotifier, directives);
    }

    public static void addDynamicUniforms(DynamicUniformHolder uniforms) {
        IdMapUniforms.addEntityIdMapUniforms(uniforms);
        FogUniforms.addFogUniforms(uniforms);
        uniforms.uniform2i("atlasSize", () -> {
            int glId = GLStateManager.getBoundTexture();
            AbstractTexture texture = TextureTracker.INSTANCE.getTexture(glId);
            if (texture instanceof TextureMap) {
                TextureInfo info = TextureInfoCache.INSTANCE.getInfo(glId);
                return new Vector2i(info.getWidth(), info.getHeight());
            }
            return ZERO_VECTOR_2i;
        }, StateUpdateNotifiers.bindTextureNotifier);
        uniforms.uniform2i("gtextureSize", () -> {
            int glId = GLStateManager.getBoundTexture();
            TextureInfo info = TextureInfoCache.INSTANCE.getInfo(glId);
            return new Vector2i(info.getWidth(), info.getHeight());
        }, StateUpdateNotifiers.bindTextureNotifier);
        uniforms.uniform4i("blendFunc", () -> {
            if (GLStateManager.getBlendMode().isEnabled()) {
                BlendStateStack blend = GLStateManager.getBlendState();
                return new Vector4i(blend.getSrcRgb(), blend.getDstRgb(), blend.getSrcAlpha(), blend.getDstAlpha());
            }
            return ZERO_VECTOR_4i;
        }, StateUpdateNotifiers.blendFuncNotifier);
        uniforms.uniform1i("renderStage", () -> GbufferPrograms.getCurrentPhase().ordinal(), StateUpdateNotifiers.phaseChangeNotifier);
        uniforms.uniform4f("entityColor", CapturedRenderingState.INSTANCE::getCurrentEntityColor, CapturedRenderingState.INSTANCE.getEntityColorNotifier());
    }

    public static void generalCommonUniforms(UniformHolder uniforms, FrameUpdateNotifier updateNotifier, PackDirectives directives) {
        ExternallyManagedUniforms.addExternallyManagedUniforms116(uniforms);
        SmoothedVec2f eyeBrightnessSmooth = new SmoothedVec2f(directives.getEyeBrightnessHalfLife(), directives.getEyeBrightnessHalfLife(), CommonUniforms::getEyeBrightness, updateNotifier);
        uniforms.uniform1f(UniformUpdateFrequency.ONCE, "darknessFactor", () -> 0.0f).uniform1b(UniformUpdateFrequency.PER_FRAME, "hideGUI", () -> CommonUniforms.client.field_71474_y.field_74319_N).uniform1i(UniformUpdateFrequency.PER_FRAME, "isEyeInWater", CommonUniforms::isEyeInWater).uniform1f(UniformUpdateFrequency.PER_FRAME, "blindness", CommonUniforms::getBlindness).uniform1f(UniformUpdateFrequency.PER_FRAME, "nightVision", CommonUniforms::getNightVision).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_sneaking", CommonUniforms::isSneaking).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_sprinting", CommonUniforms::isSprinting).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_hurt", CommonUniforms::isHurt).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_invisible", CommonUniforms::isInvisible).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_burning", CommonUniforms::isBurning).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_on_ground", CommonUniforms::isOnGround).uniform1f(UniformUpdateFrequency.PER_FRAME, "screenBrightness", () -> CommonUniforms.client.field_71474_y.field_74333_Y).uniform1f(UniformUpdateFrequency.PER_TICK, "playerMood", CommonUniforms::getPlayerMood).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightness", CommonUniforms::getEyeBrightness).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightnessSmooth", () -> {
            Vector2f smoothed = eyeBrightnessSmooth.get();
            return new Vector2i((int)smoothed.x(), (int)smoothed.y());
        }).uniform1f(UniformUpdateFrequency.PER_TICK, "rainStrength", CommonUniforms::getRainStrength).uniform1f(UniformUpdateFrequency.PER_TICK, "wetness", new SmoothedFloat(directives.getWetnessHalfLife(), directives.getDrynessHalfLife(), CommonUniforms::getRainStrength, updateNotifier)).uniform3d(UniformUpdateFrequency.PER_FRAME, "skyColor", CommonUniforms::getSkyColor).uniform3d(UniformUpdateFrequency.PER_FRAME, "fogColor", GLStateManager::getFogColor).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_precipitation", CommonUniforms::getBiomePrecipitation).uniform1f(UniformUpdateFrequency.PER_TICK, "rainfall", CommonUniforms::getBiomeRainfall).uniform1f(UniformUpdateFrequency.PER_TICK, "temperature", CommonUniforms::getBiomeTemperature);
    }

    private static boolean isOnGround() {
        return CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.field_70122_E;
    }

    private static boolean isHurt() {
        return CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.field_70737_aN > 0;
    }

    private static BiomeGenBase getBiome() {
        return CommonUniforms.client.field_71441_e.func_72807_a(MathHelper.func_76128_c((double)CommonUniforms.client.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)CommonUniforms.client.field_71439_g.field_70161_v));
    }

    private static int getBiomePrecipitation() {
        if (CommonUniforms.client.field_71439_g == null || CommonUniforms.client.field_71441_e == null) {
            return 0;
        }
        BiomeGenBase biome = CommonUniforms.getBiome();
        float temp = biome.func_150564_a(MathHelper.func_76128_c((double)CommonUniforms.client.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)CommonUniforms.client.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)CommonUniforms.client.field_71439_g.field_70161_v));
        if (!biome.field_76765_S && !biome.field_76766_R) {
            return 0;
        }
        if (temp > 0.15f) {
            return 1;
        }
        return 2;
    }

    private static float getBiomeRainfall() {
        if (CommonUniforms.client.field_71439_g == null || CommonUniforms.client.field_71441_e == null) {
            return 0.0f;
        }
        return CommonUniforms.getBiome().field_76751_G;
    }

    private static float getBiomeTemperature() {
        if (CommonUniforms.client.field_71439_g == null || CommonUniforms.client.field_71441_e == null) {
            return 0.0f;
        }
        return CommonUniforms.getBiome().field_76750_F;
    }

    private static boolean isInvisible() {
        return CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.func_82150_aj();
    }

    private static boolean isBurning() {
        return CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.field_70151_c > 0 && !CommonUniforms.client.field_71439_g.func_70045_F();
    }

    private static boolean isSneaking() {
        return CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.func_70093_af();
    }

    private static boolean isSprinting() {
        return CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.func_70051_ag();
    }

    private static Vector3d getSkyColor() {
        if (CommonUniforms.client.field_71441_e == null || CommonUniforms.client.field_71451_h == null) {
            return ZERO_VECTOR_3d;
        }
        Vec3 skyColor = CommonUniforms.client.field_71441_e.func_72833_a((Entity)CommonUniforms.client.field_71451_h, CapturedRenderingState.INSTANCE.getTickDelta());
        return new Vector3d(skyColor.field_72450_a, skyColor.field_72448_b, skyColor.field_72449_c);
    }

    static float getBlindness() {
        PotionEffect blindness;
        EntityPlayer livingEntity;
        EntityLivingBase cameraEntity = CommonUniforms.client.field_71451_h;
        if (cameraEntity instanceof EntityPlayer && (livingEntity = (EntityPlayer)cameraEntity).func_70644_a(Potion.field_76440_q) && (blindness = livingEntity.func_70660_b(Potion.field_76440_q)) != null) {
            return Math.clamp((float)0.0f, (float)1.0f, (float)((float)blindness.func_76459_b() / 20.0f));
        }
        return 0.0f;
    }

    private static float getPlayerMood() {
        return 0.0f;
    }

    static float getRainStrength() {
        if (CommonUniforms.client.field_71441_e == null) {
            return 0.0f;
        }
        return Math.clamp((float)0.0f, (float)1.0f, (float)CommonUniforms.client.field_71441_e.func_72867_j(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static Vector2i getEyeBrightness() {
        if (CommonUniforms.client.field_71451_h == null || CommonUniforms.client.field_71441_e == null) {
            return ZERO_VECTOR_2i;
        }
        int eyeBrightness = CommonUniforms.client.field_71451_h.func_70070_b(CapturedRenderingState.INSTANCE.getTickDelta());
        return new Vector2i(eyeBrightness & 0xFFFF, eyeBrightness >> 16);
    }

    private static float getNightVision() {
        EntityLivingBase cameraEntity = CommonUniforms.client.field_71451_h;
        if (cameraEntity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)cameraEntity;
            if (!entityPlayer.func_70644_a(Potion.field_76439_r)) {
                return 0.0f;
            }
            float nightVisionStrength = ((EntityRendererAccessor)CommonUniforms.client.field_71460_t).invokeGetNightVisionBrightness(entityPlayer, CapturedRenderingState.INSTANCE.getTickDelta());
            try {
                if (nightVisionStrength > 0.0f) {
                    return Math.clamp((float)0.0f, (float)1.0f, (float)nightVisionStrength);
                }
            }
            catch (NullPointerException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    static int isEyeInWater() {
        if (CommonUniforms.client.field_71474_y.field_74320_O == 0 && !CommonUniforms.client.field_71451_h.func_70608_bn()) {
            if (CommonUniforms.client.field_71439_g.func_70055_a(Material.field_151586_h)) {
                return 1;
            }
            if (CommonUniforms.client.field_71439_g.func_70055_a(Material.field_151587_i)) {
                return 2;
            }
        }
        return 0;
    }

    static {
        GbufferPrograms.init();
    }
}

