/*
 * Decompiled with CFR 0.152.
 */
package dev.overgeneralized.confettinator;

import com.mojang.serialization.MapCodec;
import dev.doublekekse.confetti.Confetti;
import dev.doublekekse.confetti.math.Vec3Dist;
import dev.doublekekse.confetti.packet.ExtendedParticlePacket;
import dev.overgeneralized.confettinator.ConfettinatorEntity;
import dev.overgeneralized.confettinator.ConfettinatorMod;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9463;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class ConfettinatorBlock
extends class_2237 {
    public static final class_2746 TRIGGERED = class_2741.field_12522;
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    private static final Map<Integer, Integer> INT_TO_FIREWORK_COLOR = new HashMap<Integer, Integer>(Arrays.stream(class_1767.values()).collect(Collectors.toMap(class_1767::method_7789, class_1767::method_7790)));

    protected ConfettinatorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false))).method_11657(FACING, (Comparable)class_2350.field_11043));
    }

    protected MapCodec<? extends ConfettinatorBlock> method_53969() {
        return ConfettinatorBlock.method_54094(ConfettinatorBlock::new);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ConfettinatorEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_3908 screenHandlerFactory;
        if (!world.field_9236 && (screenHandlerFactory = state.method_26196(world, pos)) != null) {
            player.method_17355(screenHandlerFactory);
        }
        return class_1269.field_5812;
    }

    protected void dispense(class_3218 world, class_2680 state, class_2338 pos) {
        ConfettinatorEntity confettinatorBlockEntity = world.method_35230(pos, ConfettinatorMod.CONFETTINATOR_ENTITY).orElse(null);
        if (confettinatorBlockEntity == null) {
            return;
        }
        class_2371<class_1799> inventory = confettinatorBlockEntity.getItems();
        int index = -1;
        for (int i = 0; i < 9; ++i) {
            if (((class_1799)inventory.get(i)).method_7960()) continue;
            index = i;
            break;
        }
        world.method_43276((class_6880)class_5712.field_28174, pos, class_5712.class_7397.method_43287((class_2680)confettinatorBlockEntity.method_11010()));
        if (index < 0) {
            world.method_20290(1001, pos, 0);
            return;
        }
        class_1799 itemStack = (class_1799)inventory.get(index);
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8639) {
            int calibrationPower = this.getCalibrationPower((class_1937)world, pos, state);
            class_1799 projectileItemStack = itemStack;
            class_9463 projectileItem = (class_9463)item;
            if (calibrationPower != 0) {
                class_9284 fireworksComponent = (class_9284)itemStack.method_58694(class_9334.field_49616);
                if (fireworksComponent == null) {
                    return;
                }
                List explosions = fireworksComponent.comp_2392();
                List<Object> newExplosionList = List.of();
                if (!explosions.isEmpty()) {
                    class_9283 explosion = (class_9283)explosions.getFirst();
                    newExplosionList = List.of(new class_9283(explosion.comp_2386(), IntList.of((int)INT_TO_FIREWORK_COLOR.get(calibrationPower)), IntList.of(), explosion.comp_2389(), explosion.comp_2390()));
                }
                class_9323 components = class_9323.method_57827().method_57840(class_9334.field_49616, (Object)new class_9284(fireworksComponent.comp_2391(), newExplosionList)).method_57838();
                projectileItemStack = new class_1799((class_1935)class_1802.field_8639, 1);
                projectileItemStack.method_57365(components);
                projectileItem = (class_9463)projectileItemStack.method_7909();
            }
            class_1676.method_61552((class_1676)projectileItem.method_58648((class_1937)world, projectileItem.method_58653().comp_2544().getDispensePosition(new class_2342(world, pos, null, null), class_2350.field_11036), projectileItemStack, class_2350.field_11036), (class_3218)world, (class_1799)projectileItemStack, (double)0.0, (double)1.0, (double)0.0, (float)projectileItem.method_58653().comp_2546(), (float)projectileItem.method_58653().comp_2545());
        } else if (item == class_1802.field_8450) {
            int calibrationPower = this.getCalibrationPower((class_1937)world, pos, state);
            class_9283 explosion = (class_9283)itemStack.method_58694(class_9334.field_49615);
            assert (explosion != null);
            if (calibrationPower != 0) {
                explosion = new class_9283(explosion.comp_2386(), IntList.of((int)INT_TO_FIREWORK_COLOR.get(calibrationPower)), IntList.of(), explosion.comp_2389(), explosion.comp_2390());
            }
            class_9323 components = class_9323.method_57827().method_57840(class_9334.field_49616, (Object)new class_9284(1, List.of(explosion))).method_57838();
            class_1799 projectileItemStack = new class_1799((class_1935)class_1802.field_8639, 1);
            projectileItemStack.method_57365(components);
            class_9463 projectileItem = (class_9463)projectileItemStack.method_7909();
            class_1676 entity = class_1676.method_61552((class_1676)projectileItem.method_58648((class_1937)world, projectileItem.method_58653().comp_2544().getDispensePosition(new class_2342(world, pos, null, null), class_2350.field_11036), projectileItemStack, class_2350.field_11036), (class_3218)world, (class_1799)projectileItemStack, (double)0.0, (double)1.0, (double)0.0, (float)projectileItem.method_58653().comp_2546(), (float)projectileItem.method_58653().comp_2545());
            ((class_1671)entity).method_16830(world);
        } else if (item instanceof class_1769) {
            class_1767 color = ((class_1769)item).method_7802();
            for (class_3222 player : world.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ExtendedParticlePacket(new Vec3Dist(pos.method_10084().method_46558(), new class_243(0.0, 0.2, 0.0)), new Vec3Dist(new class_243(0.0, 0.8, 0.0), new class_243(0.1, 0.1, 0.1)), 500, false, (class_2394)ConfettinatorMod.COLOR_CONFETTI_PAR_LIST[color.method_7789()]));
            }
        } else if (item == class_1802.field_8407) {
            int calibrationPower = this.getCalibrationPower((class_1937)world, pos, state);
            for (class_3222 player : world.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ExtendedParticlePacket(new Vec3Dist(pos.method_10084().method_46558(), new class_243(0.0, 0.2, 0.0)), new Vec3Dist(new class_243(0.0, 0.8, 0.0), new class_243(0.1, 0.1, 0.1)), 500, false, (class_2394)ConfettinatorMod.COLOR_CONFETTI_PAR_LIST[calibrationPower]));
            }
        } else if (item == class_1802.field_8601) {
            for (class_3222 player : world.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ExtendedParticlePacket(new Vec3Dist(pos.method_10084().method_46558(), new class_243(0.0, 0.2, 0.0)), new Vec3Dist(new class_243(0.0, 0.8, 0.0), new class_243(0.1, 0.1, 0.1)), 500, false, (class_2394)Confetti.CONFETTI));
            }
        } else {
            world.method_20290(1001, pos, 0);
            return;
        }
        world.method_20290(1000, pos, 0);
        itemStack.method_7934(1);
        inventory.set(index, (Object)itemStack);
    }

    private int getCalibrationPower(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        return world.method_49808(pos.method_10093(direction), direction);
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        boolean receivingPower = this.isReceivingRedstonePower(world, pos, state);
        boolean currentlyPowered = (Boolean)state.method_11654((class_2769)TRIGGERED);
        if (receivingPower && !currentlyPowered) {
            world.method_64310(pos, (class_2248)this, 4);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (!receivingPower && currentlyPowered) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private boolean isReceivingRedstonePower(class_1937 world, class_2338 pos, class_2680 state) {
        for (class_2350 direction : field_23157) {
            if (direction == state.method_11654(FACING) || world.method_49808(pos.method_10093(direction), direction) <= 0) continue;
            return true;
        }
        return false;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.dispense(world, state, pos);
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        class_1264.method_66221((class_2680)state, (class_1937)world, (class_2338)pos);
        ConfettinatorEntity blockEntity = world.method_35230(pos, ConfettinatorMod.CONFETTINATOR_ENTITY).orElse(null);
        if (blockEntity == null) {
            return;
        }
        class_1264.method_17349((class_1937)world, (class_2338)pos, blockEntity.getItems());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TRIGGERED, FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }
}

