/*
 * Decompiled with CFR 0.152.
 */
package dev.nekokitsune.holdablefrogs.render;

import dev.nekokitsune.holdablefrogs.entity.FrogTongueEntity;
import dev.nekokitsune.holdablefrogs.util.FrogTongueUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public class FrogTongueRenderer
extends class_897<FrogTongueEntity> {
    private static final float TONGUE_THICKNESS = 0.05f;
    private static final class_2960 TEXTURE = new class_2960("textures/entity/fishing_hook.png");

    public FrogTongueRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(FrogTongueEntity tongue, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_1657 player = (class_1657)tongue.method_24921();
        if (player == null) {
            return;
        }
        matrices.method_22903();
        class_243 cameraPos = this.field_4676.field_4686.method_19326();
        class_243 handPos = FrogTongueUtil.getHandPosition(player, class_1268.field_5808, tickDelta);
        double handX = handPos.field_1352 - cameraPos.field_1352;
        double handY = handPos.field_1351 - cameraPos.field_1351;
        double handZ = handPos.field_1350 - cameraPos.field_1350;
        class_243 tonguePos = tongue.method_30950(tickDelta);
        double tongueX = tonguePos.field_1352 - cameraPos.field_1352;
        double tongueY = tonguePos.field_1351 - cameraPos.field_1351 + 0.25;
        double tongueZ = tonguePos.field_1350 - cameraPos.field_1350;
        float dx = (float)(handX - tongueX);
        float dy = (float)(handY - tongueY);
        float dz = (float)(handZ - tongueZ);
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23587());
        class_4587.class_4665 entry = matrices.method_23760();
        int segments = 16;
        for (int i = 0; i < segments; ++i) {
            FrogTongueRenderer.renderTongueSegment(dx, dy, dz, buffer, entry, FrogTongueRenderer.percentage(i, segments), FrogTongueRenderer.percentage(i + 1, segments), light);
        }
        matrices.method_22909();
        super.method_3936((class_1297)tongue, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private static float percentage(int value, int max) {
        return (float)value / (float)max;
    }

    private static void renderTongueSegment(float dx, float dy, float dz, class_4588 buffer, class_4587.class_4665 entry, float t1, float t2, int light) {
        class_243 side;
        float x2 = dx * t2;
        float y2 = dy * (t2 * t2 + t2) * 0.5f + 0.25f;
        float z2 = dz * t2;
        class_243 end = new class_243((double)x2, (double)y2, (double)z2);
        float x1 = dx * t1;
        float y1 = dy * (t1 * t1 + t1) * 0.5f + 0.25f;
        float z1 = dz * t1;
        class_243 start = new class_243((double)x1, (double)y1, (double)z1);
        class_243 dir = end.method_1020(start).method_1029();
        if (dir.method_1027() == 0.0) {
            dir = new class_243(0.0, 1.0, 0.0);
        }
        if ((side = new class_243(0.0, 1.0, 0.0).method_1036(dir).method_1029().method_1021((double)0.025f)).method_1027() == 0.0) {
            side = new class_243(0.05, 0.0, 0.0);
        }
        class_243 sL = start.method_1019(side);
        class_243 sR = start.method_1020(side);
        class_243 eL = end.method_1019(side);
        class_243 eR = end.method_1020(side);
        FrogTongueRenderer.addVertex(buffer, entry, sL, light);
        FrogTongueRenderer.addVertex(buffer, entry, eL, light);
        FrogTongueRenderer.addVertex(buffer, entry, eR, light);
        FrogTongueRenderer.addVertex(buffer, entry, sL, light);
        FrogTongueRenderer.addVertex(buffer, entry, eR, light);
        FrogTongueRenderer.addVertex(buffer, entry, sR, light);
    }

    private static void addVertex(class_4588 buffer, class_4587.class_4665 entry, class_243 pos, int light) {
        buffer.method_22918(entry.method_23761(), (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_1336(230, 20, 20, 255).method_22916(light).method_23763(entry.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
    }

    public class_2960 getTexture(FrogTongueEntity entity) {
        return TEXTURE;
    }
}

