package com.chyzman.armmersive;

import com.mojang.serialization.Codec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_7172;
import net.minecraft.class_7291;
import org.jetbrains.annotations.Nullable;

import java.util.*;

@Environment(EnvType.CLIENT)
public class Armmersive {
    public static final String MODID = "armmersive";
    @Nullable
    public static class_1306 renderingArm = null;

    public static String optionKey(String key) {
        return "options." + MODID + "." + key;
    }

    public static final Map<String, class_7172<?>> OPTIONS = new LinkedHashMap<>();

    public static final class_7172<ArmDisplayMode> MAIN_HAND_DISPLAY_MODE = register("main_hand_display_mode", ArmDisplayMode.ALWAYS);
    public static final class_7172<ArmDisplayMode> OFF_HAND_DISPLAY_MODE = register("off_hand_display_mode", ArmDisplayMode.WHEN_FULL);

    public static class_7172<ArmDisplayMode> getDisplayMode(class_1268 hand) {
        return hand == class_1268.field_5808 ? MAIN_HAND_DISPLAY_MODE : OFF_HAND_DISPLAY_MODE;
    }

    public static final class_7172<Boolean> FIRST_PERSON_ARMOR = register("first_person_armor", true);

    public static <T> class_7172<T> register(String key, class_7172<T> option) {
        OPTIONS.put(key, option);
        return option;
    }
    public static <T extends Enum<T> & class_7291> class_7172<T> register(String key, T defaultValue) {
        var constants = defaultValue.getDeclaringClass().getEnumConstants();
        key = optionKey(key);
        return register(
            key,
            new class_7172<>(
                key,
                class_7172.method_42399(),
                class_7172.method_42720(),
                new class_7172.class_7173<>(Arrays.asList(constants), Codec.INT.xmap(i -> constants[i], Enum::ordinal)),
                defaultValue,
                value -> {}
            )
        );
    }

    public static class_7172<Boolean> register(String key, boolean defaultValue) {
        key = optionKey(key);
        return register(key, class_7172.method_42402(key, defaultValue));
    }
}
