package com.chyzman.armmersive.mixin;

import com.chyzman.armmersive.Armmersive;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_1306;
import net.minecraft.class_310;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import net.minecraft.class_970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import static net.minecraft.class_1304.field_6174;

@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin extends class_922<class_742, class_10055, class_591> {

    @Shadow public abstract class_10055 method_55269();

    @Shadow public abstract void updateRenderState(
        class_742 abstractClientPlayerEntity,
        class_10055 playerEntityRenderState,
        float f
    );

    @Unique private class_970<class_10055, class_591, class_591> armorFeatureRenderer;

    public PlayerEntityRendererMixin(
        class_5617.class_5618 ctx,
        class_591 model,
        float shadowRadius
    ) {
        super(ctx, model, shadowRadius);
    }

    @SuppressWarnings("unchecked")
    @WrapOperation(
        method = "<init>",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/entity/PlayerEntityRenderer;addFeature(Lnet/minecraft/client/render/entity/feature/FeatureRenderer;)Z"
        )
    )
    private boolean grabArmorFeatureRenderer(
        class_1007 instance,
        class_3887<class_10055, class_591> featureRenderer,
        Operation<Boolean> original
    ) {
        if (featureRenderer instanceof class_970<?, ?, ?> armor)
            this.armorFeatureRenderer = (class_970<class_10055, class_591, class_591>) armor;
        return original.call(instance, featureRenderer);
    }

    @WrapOperation(
        method = "renderArm",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/model/ModelPart;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;II)V"
        )
    )
    private void renderArmorInFirstPerson(
        class_630 instance,
        class_4587 matrices,
        class_4588 vertices,
        int light,
        int overlay,
        Operation<Void> original,
        @Local(argsOnly = true) class_4597 vertexConsumers
    ) {
        var client = class_310.method_1551();
        var player = client.field_1724;
        if (player == null) return;
        if (!client.field_1724.method_5767()) original.call(instance, matrices, vertices, light, overlay);
        if (!Armmersive.FIRST_PERSON_ARMOR.method_41753()) return;
        if (this.armorFeatureRenderer == null) return;
        var tickDelta = client.method_61966().method_60637(true);
        var chestStack = player.method_6118(field_6174);
        if (!chestStack.method_7960()) {
            Armmersive.renderingArm = instance == this.field_4737.field_27433 ? class_1306.field_6182 : class_1306.field_6183;
            var renderState = this.method_55269();
            this.updateRenderState(player, renderState, tickDelta);
            armorFeatureRenderer.method_17157(matrices, vertexConsumers, light, renderState, renderState.field_53447, renderState.field_53448);
            Armmersive.renderingArm = null;
        }
    }
}
