package com.chyzman.armmersive;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_7291;

@Environment(EnvType.CLIENT)
public enum ArmDisplayMode implements class_7291 {
    ALWAYS("always", true, true),
    WHEN_FULL("when_full", false, true),
    NEVER( "never", false, false);

    public final String translationKey;
    public final boolean showWhenEmpty;
    public final boolean showWhenFull;

    ArmDisplayMode(
        final String translationKey,
        final boolean showWhenEmpty,
        final boolean showWhenFull
    ) {
        this.translationKey = Armmersive.optionKey("arm_display_mode." + translationKey);
        this.showWhenEmpty = showWhenEmpty;
        this.showWhenFull = showWhenFull;
    }

    @Override
    public int method_7362() {
        return ordinal();
    }

    @Override
    public String method_7359() {
        return this.translationKey;
    }
}
