/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.attribute;

import fr.maxlego08.menu.api.attribute.IAttribute;
import java.util.Map;
import java.util.UUID;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.NumberConversions;

public class Attribute
implements IAttribute {
    private static final String TYPE = "attribute";
    private static final String UUID = "uuid";
    private static final String NAME = "name";
    private static final String AMOUNT = "amount";
    private static final String SLOT = "slot";
    private final Type type;
    private final UUID uuid;
    private final String name;
    private final double amount;
    private final EquipmentSlot slot;

    public static Builder builder(Type type, double amount) {
        return new Builder(type, amount);
    }

    Attribute(Type type, UUID uuid, String name, double amount, EquipmentSlot slot) {
        this.type = type;
        this.uuid = uuid;
        this.name = name;
        this.amount = amount;
        this.slot = slot;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public static Attribute deserialize(Map<String, Object> map) {
        if (!map.containsKey(TYPE) || map.get(TYPE) == null) {
            throw new IllegalArgumentException(String.format("The '%s' field is missing or null", TYPE));
        }
        Type type = Type.valueOf((String)map.get(TYPE));
        if (!map.containsKey(AMOUNT) || map.get(AMOUNT) == null) {
            throw new IllegalArgumentException(String.format("The '%s' field is missing or null", AMOUNT));
        }
        double amount = NumberConversions.toDouble((Object)map.get(AMOUNT));
        Builder builder = Attribute.builder(type, amount);
        if (map.containsKey(NAME) && map.get(NAME) != null) {
            builder.withName((String)map.get(NAME));
        }
        if (map.containsKey(SLOT) && map.get(SLOT) != null) {
            builder.withSlot(EquipmentSlot.valueOf((String)((String)map.get(SLOT))));
        }
        if (map.containsKey(UUID) && map.get(UUID) != null) {
            builder.withUUID(java.util.UUID.fromString((String)map.get(UUID)));
        }
        return builder.build();
    }

    public static final class Builder {
        final Type type;
        final double amount;
        UUID uuid = java.util.UUID.randomUUID();
        String name = "zmenu:modifier";
        EquipmentSlot slot = null;

        Builder(Type type, double amount) {
            this.amount = amount;
            this.type = type;
        }

        public Attribute build() {
            return new Attribute(this.type, this.uuid, this.name, this.amount, this.slot);
        }

        public Builder withUUID(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSlot(EquipmentSlot slot) {
            this.slot = slot;
            return this;
        }
    }

    public static enum Type {
        GENERIC_MAX_HEALTH("generic.max_health"),
        GENERIC_FOLLOW_RANGE("generic.follow_range"),
        GENERIC_KNOCKBACK_RESISTANCE("generic.knockback_resistance"),
        GENERIC_MOVEMENT_SPEED("generic.movement_speed"),
        GENERIC_FLYING_SPEED("generic.flying_speed"),
        GENERIC_ATTACK_DAMAGE("generic.attack_damage"),
        GENERIC_ATTACK_KNOCKBACK("generic.attack_knockback"),
        GENERIC_ATTACK_SPEED("generic.attack_speed"),
        GENERIC_ARMOR("generic.armor"),
        GENERIC_ARMOR_TOUGHNESS("generic.armor_toughness"),
        GENERIC_LUCK("generic.luck"),
        GENERIC_MAX_ABSORPTION("generic.max_absorption"),
        HORSE_JUMP_STRENGTH("horse.jump_strength"),
        ZOMBIE_SPAWN_REINFORCEMENTS("zombie.spawn_reinforcements");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

