/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.button;

import fr.maxlego08.menu.api.button.PermissibleButton;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.permissible.PlaceholderPermissible;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class PlaceholderButton
extends PermissibleButton {
    private List<PlaceholderPermissible> placeholders = new ArrayList<PlaceholderPermissible>();

    public List<PlaceholderPermissible> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(List<PlaceholderPermissible> placeholders) {
        this.placeholders = placeholders;
    }

    public boolean hasPlaceHolder() {
        return this.placeholders != null && !this.placeholders.isEmpty();
    }

    @Override
    public boolean hasPermission() {
        return this.hasPlaceHolder() || super.hasPermission();
    }

    @Override
    public boolean checkPermission(Player player, InventoryEngine inventoryEngine, Placeholders placeholders) {
        if (!super.checkPermission(player, inventoryEngine, placeholders)) {
            return false;
        }
        if (this.placeholders.isEmpty()) {
            return true;
        }
        for (PlaceholderPermissible placeholder : this.placeholders) {
            if (placeholder.hasPermission(player, null, inventoryEngine, placeholders)) continue;
            return false;
        }
        return true;
    }
}

