/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.checker;

import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.checker.InventoryRequirementType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class InventoryLoadRequirement {
    private final Plugin plugin;
    private final YamlConfiguration configuration;
    private final Class<? extends Inventory> classz;
    private final File file;
    private final Map<InventoryRequirementType, List<String>> requirements = new HashMap<InventoryRequirementType, List<String>>();

    public InventoryLoadRequirement(Plugin plugin, YamlConfiguration configuration, Class<? extends Inventory> classz, File file) {
        this.plugin = plugin;
        this.configuration = configuration;
        this.classz = classz;
        this.file = file;
        for (InventoryRequirementType value : InventoryRequirementType.values()) {
            this.requirements.put(value, new ArrayList());
        }
    }

    public File getFile() {
        return this.file;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }

    public Class<? extends Inventory> getClassz() {
        return this.classz;
    }

    public void addRequirement(InventoryRequirementType inventoryRequirementType, String name) {
        this.requirements.get((Object)inventoryRequirementType).add(name);
    }

    public void removeRequirement(InventoryRequirementType inventoryRequirementType, String name) {
        this.requirements.get((Object)inventoryRequirementType).removeIf(e -> e.equalsIgnoreCase(name));
    }

    public boolean canLoad() {
        for (List<String> names : this.requirements.values()) {
            if (names.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<InventoryRequirementType, List<String>> getRequirements() {
        return this.requirements;
    }

    public String getDisplayError() {
        StringBuilder sb = new StringBuilder();
        this.requirements.forEach((type, names) -> {
            if (!names.isEmpty()) {
                sb.append(type.name().toUpperCase()).append(" : ");
                sb.append(String.join((CharSequence)", ", names));
                sb.append("\n");
            }
        });
        return sb.toString();
    }

    public String toString() {
        return "InventoryLoadRequirement{plugin=" + String.valueOf(this.plugin) + ", configuration=" + String.valueOf(this.configuration) + ", classz=" + String.valueOf(this.classz) + ", file=" + String.valueOf(this.file) + ", requirements=" + String.valueOf(this.requirements) + "}";
    }
}

