/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.enums;

import java.util.Arrays;
import java.util.List;

public enum PlaceholderAction {
    BOOLEAN("b="),
    EQUALS_STRING("s="),
    DIFFERENT_STRING("s!="),
    EQUALSIGNORECASE_STRING("s=="),
    CONTAINS_STRING("sc"),
    EQUAL_TO("=="),
    SUPERIOR(">"),
    SUPERIOR_OR_EQUAL(">="),
    LOWER("<"),
    LOWER_OR_EQUAL("<=");

    private final List<String> aliases;

    private PlaceholderAction(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
    }

    public static PlaceholderAction from(String string) {
        if (string == null) {
            return null;
        }
        for (PlaceholderAction action : PlaceholderAction.values()) {
            if (action.name().equalsIgnoreCase(string)) {
                return action;
            }
            for (String alias : action.aliases) {
                if (!alias.equalsIgnoreCase(string)) continue;
                return action;
            }
        }
        System.err.println("Impossible to find the " + string + " action for placeholder");
        return null;
    }

    public boolean isString() {
        return this == EQUALS_STRING || this == EQUALSIGNORECASE_STRING || this == CONTAINS_STRING | this == DIFFERENT_STRING;
    }
}

