/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.itemstack;

import java.util.Collection;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class Potion {
    private static final int EXTENDED_BIT = 64;
    private static final int POTION_BIT = 15;
    private static final int SPLASH_BIT = 16384;
    private static final int TIER_BIT = 32;
    private static final int TIER_SHIFT = 5;
    private static PotionBrewer brewer;
    private boolean extended = false;
    private boolean splash = false;
    private boolean arrow = false;
    private int level = 1;
    private PotionType type;
    private Color color;

    public Potion(PotionType type) {
        this.type = type;
    }

    public Potion(PotionType type, int level) {
        this(type);
        this.level = level;
    }

    public Potion(PotionType type, int level, boolean splash) {
        this(type, level);
        this.splash = splash;
    }

    public Potion(PotionType type, int level, boolean splash, boolean extended, boolean isArrow) {
        this(type, level, splash);
        this.extended = extended;
        this.arrow = isArrow;
    }

    public static Potion fromDamage(int damage) {
        Potion potion;
        PotionType type;
        switch (damage & 0xF) {
            case 1: {
                PotionType potionType = PotionType.valueOf((String)"REGEN");
                break;
            }
            case 2: {
                PotionType potionType = PotionType.valueOf((String)"SPEED");
                break;
            }
            case 3: {
                PotionType potionType = PotionType.FIRE_RESISTANCE;
                break;
            }
            case 4: {
                PotionType potionType = PotionType.POISON;
                break;
            }
            case 5: {
                PotionType potionType = PotionType.valueOf((String)"INSTANT_HEAL");
                break;
            }
            case 6: {
                PotionType potionType = PotionType.NIGHT_VISION;
                break;
            }
            case 8: {
                PotionType potionType = PotionType.WEAKNESS;
                break;
            }
            case 9: {
                PotionType potionType = PotionType.STRENGTH;
                break;
            }
            case 10: {
                PotionType potionType = PotionType.SLOWNESS;
                break;
            }
            case 11: {
                PotionType potionType = PotionType.valueOf((String)"JUMP");
                break;
            }
            case 12: {
                PotionType potionType = PotionType.valueOf((String)"INSTANT_DAMAGE");
                break;
            }
            case 13: {
                PotionType potionType = PotionType.WATER_BREATHING;
                break;
            }
            case 14: {
                PotionType potionType = PotionType.INVISIBILITY;
                break;
            }
            default: {
                PotionType potionType = type = PotionType.WATER;
            }
        }
        if (type == PotionType.WATER) {
            potion = new Potion(PotionType.WATER);
        } else {
            int level = (damage & 0x20) >> 5;
            potion = new Potion(type, ++level);
        }
        if ((damage & 0x4000) != 0) {
            potion = potion.splash();
        }
        if ((damage & 0x40) != 0) {
            potion = potion.extend();
        }
        return potion;
    }

    public static PotionBrewer getBrewer() {
        return brewer;
    }

    public static void setPotionBrewer(PotionBrewer other) {
        if (brewer != null) {
            throw new IllegalArgumentException("brewer can only be set internally");
        }
        brewer = other;
    }

    public Potion splash() {
        this.setSplash(true);
        return this;
    }

    public Potion extend() {
        this.setHasExtendedDuration(true);
        return this;
    }

    public Potion arrow() {
        this.setArrow(true);
        return this;
    }

    public void apply(ItemStack to) {
        PotionMeta meta = (PotionMeta)to.getItemMeta();
        meta.setBasePotionData(new PotionData(this.type, this.extended, this.level == 2));
        to.setItemMeta((ItemMeta)meta);
    }

    public void apply(LivingEntity to) {
        to.addPotionEffects(this.getEffects());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Potion other = (Potion)obj;
        return this.extended == other.extended && this.splash == other.splash && this.level == other.level && this.type == other.type;
    }

    public Collection<PotionEffect> getEffects() {
        return Potion.getBrewer().getEffects(this.type, this.level == 2, this.extended);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public PotionType getType() {
        return this.type;
    }

    public void setType(PotionType type) {
        this.type = type;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean hasExtendedDuration() {
        return this.extended;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.level;
        result = 31 * result + (this.extended ? 1231 : 1237);
        result = 31 * result + (this.splash ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean isSplash() {
        return this.splash;
    }

    public void setSplash(boolean isSplash) {
        this.splash = isSplash;
    }

    public void setHasExtendedDuration(boolean isExtended) {
        this.extended = isExtended;
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public void setArrow(boolean isArrow) {
        this.arrow = isArrow;
    }

    public short toDamageValue() {
        return 0;
    }

    public ItemStack toItemStack(int amount) {
        Material material = this.isArrow() ? Material.TIPPED_ARROW : (this.isSplash() ? Material.SPLASH_POTION : Material.POTION);
        ItemStack itemStack = new ItemStack(material, amount);
        PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
        meta.setBasePotionData(new PotionData(this.type, this.extended, this.level == 2));
        if (this.color != null) {
            meta.setColor(this.color);
        }
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public int getNameId() {
        return 0;
    }
}

