/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.requirement;

import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class Action {
    private int delay;
    private float chance;

    protected abstract void execute(Player var1, Button var2, InventoryEngine var3, Placeholders var4);

    public void preExecute(Player player, Button button, InventoryEngine inventoryEngine, Placeholders placeholders) {
        placeholders.register("player", player.getName());
        if (this.chance < 100.0f && Math.random() > (double)(this.chance / 100.0f)) {
            return;
        }
        if (this.delay == 0) {
            this.execute(player, button, inventoryEngine, placeholders);
        } else {
            inventoryEngine.getPlugin().getScheduler().runAtEntityLater((Entity)player, () -> this.execute(player, button, inventoryEngine, placeholders), (long)this.delay);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        if (chance < 0.0f || chance > 100.0f) {
            if (Config.enableDebug) {
                throw new IllegalArgumentException("Chance must be between 0 and 100");
            }
            chance = 100.0f;
        }
        this.chance = chance;
    }

    protected List<String> parseAndFlattenCommands(List<String> liste, Player player) {
        ArrayList<String> commands = new ArrayList<String>();
        String playerName = player.getName();
        for (String cmd : liste) {
            String[] split;
            for (String part : split = cmd.split("\n")) {
                commands.add(part.replace("%player%", playerName));
            }
        }
        return commands;
    }
}

