/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Placeholders {
    private final Map<String, String> placeholders;

    public Placeholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public Placeholders() {
        this(new HashMap<String, String>());
    }

    public void register(String key, String value) {
        this.placeholders.put(key, value);
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public List<String> parse(List<String> strings) {
        ArrayList<String> parsed = new ArrayList<String>(strings.size());
        for (String string : strings) {
            parsed.add(this.parse(string));
        }
        return parsed;
    }

    public String parse(String string) {
        for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
            string = this.parse(string, entry.getKey(), entry.getValue());
        }
        return string;
    }

    public String parse(String string, String key, String value) {
        try {
            if (string.contains("%" + key + "%")) {
                string = string.replace("%" + key + "%", value);
            }
            if (string.contains("%upper_" + key + "%")) {
                string = string.replace("%upper_" + key + "%", value.toUpperCase());
            }
            if (string.contains("%lower_" + key + "%")) {
                string = string.replace("%lower_" + key + "%", value.toLowerCase());
            }
            if (string.contains("%capitalize_" + key + "%")) {
                String capitalize = value.isEmpty() ? value : value.substring(0, 1).toUpperCase() + value.substring(1);
                string = string.replace("%capitalize_" + key + "%", capitalize);
            }
            if (string.contains("%add_one_" + key + "%")) {
                try {
                    string = string.replace("%add_one_" + key + "%", String.valueOf(Integer.parseInt(value) + 1));
                }
                catch (NumberFormatException capitalize) {
                    // empty catch block
                }
            }
            if (string.contains("%remove_one_" + key + "%")) {
                try {
                    string = string.replace("%remove_one_" + key + "%", String.valueOf(Integer.parseInt(value) - 1));
                }
                catch (NumberFormatException capitalize) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error with placeholder key " + key + " !");
        }
        return string;
    }
}

