/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.utils;

import fr.maxlego08.menu.api.utils.MapConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TypedMapAccessor
implements MapConfiguration {
    private final Map<String, Object> map;

    public TypedMapAccessor(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public String getString(String key) {
        return String.valueOf(this.map.get(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.map.containsKey(key) ? String.valueOf(this.map.get(key)) : defaultValue;
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        Object value = this.map.get(key);
        try {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        Object value = this.map.get(key);
        try {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public List<String> getStringList(String key) {
        return this.map.getOrDefault(key, Collections.emptyList());
    }

    @Override
    public List<String> getStringList(String key, List<String> defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public List<Integer> getIntList(String key) {
        Object value = this.map.get(key);
        if (value instanceof List) {
            List list = (List)value;
            return this.convertToIntegerList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Integer> getIntList(String key, List<Integer> defaultValue) {
        Object value = this.map.get(key);
        if (value instanceof List) {
            List list = (List)value;
            return this.convertToIntegerList(list);
        }
        return defaultValue;
    }

    private List<Integer> convertToIntegerList(List<?> list) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (Object obj : list) {
            if (!(obj instanceof Number)) continue;
            intList.add(((Number)obj).intValue());
        }
        return intList;
    }

    @Override
    public boolean getBoolean(String key) {
        return (Boolean)this.map.getOrDefault(key, false);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.map.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        Object value = this.map.get(key);
        try {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public Object getObject(String key) {
        return this.map.get(key);
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        Object value = this.map.get(key);
        try {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            if (value instanceof String) {
                return Float.parseFloat((String)value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public List<?> getList(String key) {
        return (List)this.map.get(key);
    }

    @Override
    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public String toString() {
        return "TypedMapAccessor{map=" + String.valueOf(this.map) + "}";
    }
}

