/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.utils;

import fr.maxlego08.menu.api.utils.MapConfiguration;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlConfigurationAccessor
implements MapConfiguration {
    private final YamlConfiguration yamlConfig;
    private final String path;

    public YamlConfigurationAccessor(YamlConfiguration yamlConfig, String path) {
        this.yamlConfig = yamlConfig;
        this.path = path;
    }

    private String getPath(String key) {
        return this.path + "." + key;
    }

    @Override
    public String getString(String key) {
        return this.yamlConfig.getString(this.getPath(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.yamlConfig.getString(this.getPath(key), defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.yamlConfig.getInt(this.getPath(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.yamlConfig.getInt(this.getPath(key), defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.yamlConfig.getLong(this.getPath(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.yamlConfig.getLong(this.getPath(key), defaultValue);
    }

    @Override
    public List<String> getStringList(String key) {
        return this.yamlConfig.getStringList(this.getPath(key));
    }

    @Override
    public List<String> getStringList(String key, List<String> defaultValue) {
        List<String> list = this.yamlConfig.getStringList(this.getPath(key));
        return list != null ? list : defaultValue;
    }

    @Override
    public List<Integer> getIntList(String key) {
        ConfigurationSection section = this.yamlConfig.getConfigurationSection(this.getPath(key));
        if (section != null) {
            return section.getIntegerList(this.getPath(key));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Integer> getIntList(String key, List<Integer> defaultValue) {
        List<Integer> list = this.getIntList(key);
        return !list.isEmpty() ? list : defaultValue;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.yamlConfig.getBoolean(this.getPath(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.yamlConfig.getBoolean(this.getPath(key), defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.yamlConfig.getDouble(this.getPath(key));
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.yamlConfig.getDouble(this.getPath(key), defaultValue);
    }

    @Override
    public Object getObject(String key) {
        return this.yamlConfig.get(this.getPath(key));
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        return this.yamlConfig.get(this.getPath(key), defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return (float)this.yamlConfig.getDouble(this.getPath(key));
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return (float)this.yamlConfig.getDouble(this.getPath(key), (double)defaultValue);
    }

    @Override
    public List<?> getList(String key) {
        return this.yamlConfig.getList(this.getPath(key));
    }

    @Override
    public boolean contains(String key) {
        return this.yamlConfig.contains(this.getPath(key));
    }
}

