/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.Arguments;
import fr.maxlego08.menu.zcore.utils.commands.CollectionBiConsumer;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import fr.maxlego08.menu.zcore.utils.commands.Tab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class VCommand
extends Arguments {
    protected final ZMenuPlugin plugin;
    protected VCommand parent;
    protected final List<VCommand> subVCommands = new ArrayList<VCommand>();
    protected CommandSender sender;
    protected Player player;
    protected final Map<Integer, CollectionBiConsumer> tabCompletions = new HashMap<Integer, CollectionBiConsumer>();
    private String permission;
    private String denyMessage;
    private final List<String> subCommands = new ArrayList<String>();
    private final List<String> requireArgs = new ArrayList<String>();
    private final List<String> optionalArgs = new ArrayList<String>();
    private boolean consoleCanUse = true;
    private boolean ignoreParent = false;
    private boolean ignoreArgs = false;
    private boolean extendedArgs = false;
    private CommandType tabCompleter = CommandType.DEFAULT;
    private String syntax;
    private String description;
    private int argsMinLength;
    private int argsMaxLength;

    public VCommand(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    public Optional<CollectionBiConsumer> getCompletionAt(int index) {
        return Optional.ofNullable(this.tabCompletions.getOrDefault(index, null));
    }

    public String getPermission() {
        return this.permission;
    }

    protected VCommand setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    protected VCommand setPermission(Permission permission) {
        this.permission = permission.getPermission();
        return this;
    }

    public VCommand getParent() {
        return this.parent;
    }

    protected VCommand setParent(VCommand parent) {
        this.parent = parent;
        return this;
    }

    public List<String> getSubCommands() {
        return this.subCommands;
    }

    public boolean isConsoleCanUse() {
        return this.consoleCanUse;
    }

    protected VCommand setConsoleCanUse(boolean consoleCanUse) {
        this.consoleCanUse = consoleCanUse;
        return this;
    }

    public boolean isIgnoreParent() {
        return this.ignoreParent;
    }

    public void setIgnoreParent(boolean ignoreParent) {
        this.ignoreParent = ignoreParent;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public int getArgsMinLength() {
        return this.argsMinLength;
    }

    public int getArgsMaxLength() {
        return this.argsMaxLength;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getSyntax() {
        if (this.syntax == null) {
            this.syntax = this.generateDefaultSyntax("");
        }
        return this.syntax;
    }

    protected VCommand setSyntax(String syntax) {
        this.syntax = syntax;
        return this;
    }

    public boolean isIgnoreArgs() {
        return this.ignoreArgs;
    }

    public void setIgnoreArgs(boolean ignoreArgs) {
        this.ignoreArgs = ignoreArgs;
    }

    public String getDescription() {
        return this.description == null ? "no description" : this.description;
    }

    protected VCommand setDescription(String description) {
        this.description = description;
        return this;
    }

    protected VCommand setDescription(Message description) {
        this.description = description.getMessage();
        return this;
    }

    public CommandType getTabCompleter() {
        return this.tabCompleter;
    }

    protected void setTabCompletor() {
        this.tabCompleter = CommandType.SUCCESS;
    }

    protected void addRequireArg(String message) {
        this.requireArgs.add(message);
        this.ignoreParent = this.parent == null;
        this.ignoreArgs = true;
    }

    protected void addRequireArg(String message, CollectionBiConsumer runnable) {
        this.addRequireArg(message);
        int index = this.requireArgs.size();
        this.addCompletion(index - 1, runnable);
    }

    protected void addOptionalArg(String message) {
        this.optionalArgs.add(message);
        this.ignoreParent = this.parent == null;
        this.ignoreArgs = true;
    }

    protected void addOptionalArg(String message, CollectionBiConsumer runnable) {
        this.addOptionalArg(message);
        int index = this.requireArgs.size() + this.optionalArgs.size();
        this.addCompletion(index - 1, runnable);
    }

    public String getFirst() {
        return this.subCommands.getFirst();
    }

    public void setExtendedArgs(boolean extendedArgs) {
        this.extendedArgs = extendedArgs;
    }

    public VCommand addSubCommand(String subCommand) {
        this.subCommands.add(subCommand);
        return this;
    }

    public VCommand addSubCommand(VCommand command) {
        command.setParent(this);
        this.plugin.getVCommandManager().registerCommand(command);
        this.subVCommands.add(command);
        return this;
    }

    public VCommand addSubCommand(String ... subCommand) {
        this.subCommands.addAll(Arrays.asList(subCommand));
        return this;
    }

    public void addCompletion(int index, CollectionBiConsumer runnable) {
        this.tabCompletions.put(index, runnable);
        this.setTabCompletor();
    }

    private String generateDefaultSyntax(String syntax) {
        StringBuilder syntaxBuilder;
        Object tmpString = this.subCommands.getFirst();
        boolean update = syntax.isEmpty();
        if (!this.requireArgs.isEmpty() && update) {
            syntaxBuilder = new StringBuilder(syntax);
            for (String string : this.requireArgs) {
                String string2 = "<" + string + ">";
                syntaxBuilder.append(" ").append(string2);
            }
            syntax = syntaxBuilder.toString();
        }
        if (!this.optionalArgs.isEmpty() && update) {
            syntaxBuilder = new StringBuilder(syntax);
            for (String string : this.optionalArgs) {
                String string3 = "[<" + string + ">]";
                syntaxBuilder.append(" ").append(string3);
            }
            syntax = syntaxBuilder.toString();
        }
        tmpString = (String)tmpString + syntax;
        if (this.parent == null) {
            return "/" + (String)tmpString;
        }
        return this.parent.generateDefaultSyntax(" " + (String)tmpString);
    }

    private int parentCount(int defaultParent) {
        return this.parent == null ? defaultParent : this.parent.parentCount(defaultParent + 1);
    }

    public CommandType prePerform(ZMenuPlugin plugin, CommandSender commandSender, String[] args) {
        this.parentCount = this.parentCount(0);
        this.argsMaxLength = this.requireArgs.size() + this.optionalArgs.size() + this.parentCount;
        this.argsMinLength = this.requireArgs.size() + this.parentCount;
        if (this.syntax == null) {
            this.syntax = this.generateDefaultSyntax("");
        }
        this.args = args;
        String defaultString = super.argAsString(0);
        if (defaultString != null) {
            for (VCommand subCommand : this.subVCommands) {
                if (!subCommand.getSubCommands().contains(defaultString.toLowerCase())) continue;
                return CommandType.CONTINUE;
            }
        }
        if (this.argsMinLength != 0 && args.length < this.argsMinLength || this.argsMaxLength != 0 && args.length > this.argsMaxLength && !this.extendedArgs) {
            return CommandType.SYNTAX_ERROR;
        }
        this.sender = commandSender;
        if (this.sender instanceof Player) {
            this.player = (Player)commandSender;
        }
        try {
            return this.perform(plugin);
        }
        catch (Exception e) {
            if (Config.enableDebug) {
                e.printStackTrace();
            }
            return CommandType.SYNTAX_ERROR;
        }
    }

    protected abstract CommandType perform(ZMenuPlugin var1);

    public boolean sameSubCommands() {
        if (this.parent == null) {
            return false;
        }
        for (String command : this.subCommands) {
            if (!this.parent.getSubCommands().contains(command)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "VCommand [permission=" + this.permission + ", subCommands=" + String.valueOf(this.subCommands) + ", consoleCanUse=" + this.consoleCanUse + ", description=" + this.description + "]";
    }

    public List<String> toTab(ZMenuPlugin plugin, CommandSender sender, String[] args) {
        this.parentCount = this.parentCount(0);
        int currentInex = args.length - this.parentCount - 1;
        Optional<CollectionBiConsumer> optional = this.getCompletionAt(currentInex);
        if (optional.isPresent()) {
            CollectionBiConsumer collectionRunnable = optional.get();
            String startWith = args[args.length - 1];
            return this.generateList(collectionRunnable.accept(sender, args), startWith);
        }
        return null;
    }

    protected List<String> generateList(String startWith, String ... strings) {
        return this.generateList(Arrays.asList(strings), startWith);
    }

    protected List<String> generateList(Tab tab, String startWith, String ... strings) {
        return this.generateList(Arrays.asList(strings), startWith, tab);
    }

    protected List<String> generateList(List<String> defaultList, String startWith) {
        return this.generateList(defaultList, startWith, Tab.CONTAINS);
    }

    protected List<String> generateList(List<String> defaultList, String startWith, Tab tab) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String str : defaultList) {
            if (!startWith.isEmpty() && !(tab.equals((Object)Tab.START) ? str.toLowerCase().startsWith(startWith.toLowerCase()) : str.toLowerCase().contains(startWith.toLowerCase()))) continue;
            newList.add(str);
        }
        return newList.isEmpty() ? null : newList;
    }

    public void addSubCommand(List<String> aliases) {
        this.subCommands.addAll(aliases);
    }

    protected void sendSyntax() {
        this.message((MenuPlugin)this.plugin, this.sender, Message.DOCUMENTATION_INFORMATION, new Object[0]);
        this.subVCommands.forEach(command -> {
            if (command.getPermission() == null || this.sender.hasPermission(command.getPermission())) {
                this.message((MenuPlugin)this.plugin, this.sender, Message.COMMAND_SYNTAX_HELP, "%syntax%", command.getSyntax(), "%description%", command.getDescription());
            }
        });
    }

    protected Optional<Inventory> findInventory(String inventoryName, InventoryManager inventoryManager) {
        String[] values;
        Optional<Inventory> optional = inventoryName.contains(":") ? ((values = inventoryName.split(":")).length == 2 ? inventoryManager.getInventory(values[0], values[1]) : inventoryManager.getInventory(inventoryName)) : inventoryManager.getInventory(inventoryName);
        return optional;
    }

    public void setDenyMessage(String denyMessage) {
        this.denyMessage = denyMessage;
    }

    public String getDenyMessage() {
        return this.denyMessage;
    }
}

