/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.command.commands.CommandInventory;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class VCommandManager
extends ZUtils
implements CommandExecutor,
TabCompleter {
    private static CommandMap commandMap;
    private static Constructor<? extends PluginCommand> constructor;
    private final ZMenuPlugin plugin;
    private final List<VCommand> commands = new ArrayList<VCommand>();

    public VCommandManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    public void validCommands() {
        this.plugin.getLog().log("Loading " + this.getUniqueCommand() + " commands", Logger.LogType.SUCCESS);
        this.commandChecking();
    }

    public void registerCommand(VCommand command) {
        this.commands.add(command);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String alias, String[] args) {
        for (VCommand command : this.commands) {
            CommandType type;
            if (!(command.getSubCommands().contains(cmd.getName().toLowerCase()) ? (args.length == 0 || command.isIgnoreParent()) && command.getParent() == null && !(type = this.processRequirements(command, sender, args)).equals((Object)CommandType.CONTINUE) : args.length >= 1 && command.getParent() != null && this.canExecute(args, cmd.getName().toLowerCase(), command) && !(type = this.processRequirements(command, sender, args)).equals((Object)CommandType.CONTINUE))) continue;
            return true;
        }
        this.message((MenuPlugin)this.plugin, sender, Message.COMMAND_NO_ARG, new Object[0]);
        return true;
    }

    private boolean canExecute(String[] args, String cmd, VCommand command) {
        for (int index = args.length - 1; index > -1; --index) {
            if (!command.getSubCommands().contains(args[index].toLowerCase())) continue;
            if (command.isIgnoreArgs() && (command.getParent() == null || this.canExecute(args, cmd, command.getParent(), index - 1))) {
                return true;
            }
            if (index < args.length - 1) {
                return false;
            }
            return this.canExecute(args, cmd, command.getParent(), index - 1);
        }
        return false;
    }

    private boolean canExecute(String[] args, String cmd, VCommand command, int index) {
        if (index < 0 && command.getSubCommands().contains(cmd.toLowerCase())) {
            return true;
        }
        if (index < 0) {
            return false;
        }
        if (command.getSubCommands().contains(args[index].toLowerCase())) {
            return this.canExecute(args, cmd, command.getParent(), index - 1);
        }
        return false;
    }

    private CommandType processRequirements(VCommand command, CommandSender sender, String[] strings) {
        if (!(sender instanceof Player) && !command.isConsoleCanUse()) {
            this.message((MenuPlugin)this.plugin, sender, Message.COMMAND_NO_CONSOLE, new Object[0]);
            return CommandType.DEFAULT;
        }
        if (command.getPermission() == null || this.hasPermission((Permissible)sender, command.getPermission())) {
            CommandType returnType = command.prePerform(this.plugin, sender, strings);
            if (returnType == CommandType.SYNTAX_ERROR) {
                this.message((MenuPlugin)this.plugin, sender, Message.COMMAND_SYNTAX_ERROR, "%syntax%", command.getSyntax());
            }
            return returnType;
        }
        if (command.getDenyMessage() != null) {
            this.messageWO((MenuPlugin)this.plugin, sender, command.getDenyMessage(), new Object[0]);
        } else {
            this.message((MenuPlugin)this.plugin, sender, Message.COMMAND_NO_PERMISSION, new Object[0]);
        }
        return CommandType.DEFAULT;
    }

    public List<VCommand> getCommands() {
        return this.commands;
    }

    private int getUniqueCommand() {
        int count = 0;
        for (VCommand command : this.commands) {
            if (command.getParent() != null) continue;
            ++count;
        }
        return count;
    }

    public void sendHelp(String commandString, CommandSender sender) {
        this.commands.forEach(command -> {
            if (this.isValid((VCommand)command, commandString) && (command.getPermission() == null || this.hasPermission((Permissible)sender, command.getPermission()))) {
                this.message((MenuPlugin)this.plugin, sender, Message.COMMAND_SYNTAX_HELP, "%syntax%", command.getSyntax(), "%description%", command.getDescription());
            }
        });
    }

    public boolean isValid(VCommand command, String commandString) {
        return command.getParent() != null ? this.isValid(command.getParent(), commandString) : command.getSubCommands().contains(commandString.toLowerCase());
    }

    private void commandChecking() {
        this.commands.forEach(command -> {
            if (command.sameSubCommands()) {
                Logger.info(String.valueOf(command) + " command to an argument similar to its parent command !", Logger.LogType.ERROR);
                this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            }
        });
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String alias, String[] args) {
        for (VCommand command : this.commands) {
            if (command.getSubCommands().contains(cmd.getName().toLowerCase())) {
                return this.processTab(sender, command, args);
            }
            String[] newArgs = Arrays.copyOf(args, args.length - 1);
            if (newArgs.length < 1 || command.getParent() == null || !this.canExecute(newArgs, cmd.getName().toLowerCase(), command)) continue;
            return this.processTab(sender, command, args);
        }
        return null;
    }

    private List<String> processTab(CommandSender sender, VCommand command, String[] args) {
        CommandType type = command.getTabCompleter();
        if (type.equals((Object)CommandType.DEFAULT)) {
            String startWith = args[args.length - 1];
            ArrayList<String> tabCompleter = new ArrayList<String>();
            for (VCommand vCommand : this.commands) {
                if (vCommand.getParent() == null || vCommand.getParent() != command) continue;
                for (String subCommand : vCommand.getSubCommands()) {
                    if (vCommand.getPermission() != null && !sender.hasPermission(vCommand.getPermission()) || !startWith.isEmpty() && !subCommand.startsWith(startWith)) continue;
                    tabCompleter.add(subCommand);
                }
            }
            return tabCompleter.isEmpty() ? null : tabCompleter;
        }
        if (type.equals((Object)CommandType.SUCCESS)) {
            return command.toTab(this.plugin, sender, args);
        }
        return null;
    }

    public void registerCommand(Plugin plugin, String string, VCommand vCommand, List<String> aliases) {
        try {
            PluginCommand command = constructor.newInstance(string, plugin);
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setAliases(aliases);
            if (vCommand.getPermission() != null && vCommand.getDenyMessage() == null) {
                command.setPermission(vCommand.getPermission());
            }
            this.commands.add(vCommand.addSubCommand(string));
            vCommand.addSubCommand(aliases);
            if (!commandMap.register(command.getName(), plugin.getDescription().getName(), (Command)command)) {
                Logger.info("Unable to add the command " + vCommand.getSyntax(), Logger.LogType.ERROR);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void registerCommand(fr.maxlego08.menu.api.command.Command command) {
        this.registerCommand(command.plugin(), command.command(), new CommandInventory(this.plugin, command, false), command.aliases());
    }

    public void unregisterCommand(fr.maxlego08.menu.api.command.Command command) {
        VCommand target = null;
        for (VCommand value : this.commands) {
            CommandInventory inventory;
            if (!(value instanceof CommandInventory) || !(inventory = (CommandInventory)value).getCommand().equals(command)) continue;
            target = value;
            break;
        }
        if (target != null) {
            this.commands.remove(target);
        }
    }

    static {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

