/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandMenuGiveOpenItem
extends VCommand {
    public CommandMenuGiveOpenItem(ZMenuPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ZMENU_OPEN_ITEM);
        this.setDescription(Message.DESCRIPTION_OPEN_ITEM);
        this.addSubCommand("giveopenitem");
        this.addSubCommand("goi");
        InventoryManager inventoryManager = plugin.getInventoryManager();
        this.addRequireArg("inventory name", (a, b) -> {
            ArrayList<String> inventories = new ArrayList<String>();
            for (Inventory inventory : inventoryManager.getInventories()) {
                inventories.add((inventory.getPlugin().getName() + ":" + inventory.getFileName()).toLowerCase());
            }
            return inventories;
        });
        this.addOptionalArg("player");
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        String inventoryName = this.argAsString(0);
        Player player = this.argAsPlayer(1, this.player);
        if (player == null) {
            this.message((MenuPlugin)plugin, this.sender, this.sender instanceof ConsoleCommandSender ? Message.INVENTORY_OPEN_ERROR_CONSOLE : Message.INVENTORY_OPEN_ERROR_PLAYER, new Object[0]);
            return CommandType.DEFAULT;
        }
        InventoryManager inventoryManager = plugin.getInventoryManager();
        Optional<Inventory> optional = this.findInventory(inventoryName, inventoryManager);
        if (optional.isEmpty()) {
            this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_ERROR_INVENTORY, "%name%", inventoryName);
            return CommandType.DEFAULT;
        }
        Inventory inventory = optional.get();
        if (inventory.getOpenWithItem() == null) {
            this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_ITEM_ERROR, "%name%", inventoryName);
            return CommandType.DEFAULT;
        }
        ItemStack itemStack = inventory.getOpenWithItem().getItemStack().build(player);
        this.give(player, itemStack);
        this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_ITEM_SUCCESS, "%name%", player.getName());
        return CommandType.SUCCESS;
    }
}

