/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandMenuOpenMainMenu
extends VCommand {
    public CommandMenuOpenMainMenu(ZMenuPlugin plugin) {
        super(plugin);
        this.addSubCommand("openMainMenu", "omm");
        this.addOptionalArg("player");
        this.addOptionalArg("display message", (a, b) -> Arrays.asList("false", "true"));
        this.setDescription(Message.DESCRIPTION_OPEN_MAIN_MENU);
        this.setPermission(Permission.ZMENU_OPEN);
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        InventoryManager inventoryManager = plugin.getInventoryManager();
        Player player = this.argAsPlayer(1, this.player);
        boolean displayMessage = this.argAsBoolean(2, Config.enableOpenMessage);
        if (player == null) {
            this.message((MenuPlugin)plugin, this.sender, this.sender instanceof ConsoleCommandSender ? Message.INVENTORY_OPEN_ERROR_CONSOLE : Message.INVENTORY_OPEN_ERROR_PLAYER, new Object[0]);
            return CommandType.DEFAULT;
        }
        String mainMenu = Config.mainMenu;
        Optional<Inventory> optional = inventoryManager.getInventory(mainMenu);
        if (optional.isEmpty()) {
            this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_ERROR_INVENTORY, "%name%", mainMenu);
            return CommandType.DEFAULT;
        }
        if (displayMessage) {
            if (this.sender == player) {
                this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_SUCCESS, "%name%", mainMenu);
            } else {
                this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_OTHER, "%name%", mainMenu, "%player%", player.getName());
            }
        }
        inventoryManager.openInventory(player, optional.get());
        return CommandType.SUCCESS;
    }
}

