/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands.dialogs;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.DialogInventory;
import fr.maxlego08.menu.api.DialogManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandDialogOpen
extends VCommand {
    public CommandDialogOpen(ZMenuPlugin plugin) {
        super(plugin);
        this.addSubCommand("open", "o");
        DialogManager dialogManager = plugin.getDialogManager();
        this.addRequireArg("dialog name", (a, b) -> {
            ArrayList<String> dialogs = new ArrayList<String>();
            for (DialogInventory dialog : dialogManager.getDialogs()) {
                dialogs.add((dialog.getPlugin().getName() + ":" + dialog.getFileName()).toLowerCase());
            }
            return dialogs;
        });
        this.addOptionalArg("player");
        this.addOptionalArg("display message", (a, b) -> Arrays.asList("true", "false"));
        this.setPermission(Permission.ZMENU_OPEN_DIALOG);
        this.setDescription(Message.DESCRIPTION_DIALOGS_OPEN);
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        DialogManager dialogManager = plugin.getDialogManager();
        String dialogName = this.argAsString(0);
        Player targetPlayer = this.argAsPlayer(1, this.player);
        boolean displayMessage = this.argAsBoolean(1, true);
        if (targetPlayer == null) {
            this.message((MenuPlugin)plugin, this.sender, this.sender instanceof ConsoleCommandSender ? Message.DIALOG_OPEN_ERROR_CONSOLE : Message.INVENTORY_OPEN_ERROR_PLAYER, new Object[0]);
            return CommandType.DEFAULT;
        }
        Optional<DialogInventory> optional = dialogManager.getDialog(dialogName);
        if (optional.isEmpty()) {
            this.message((MenuPlugin)plugin, this.sender, Message.DIALOG_OPEN_ERROR_NOT_FOUND, "%name%", dialogName);
            return CommandType.DEFAULT;
        }
        if (displayMessage) {
            if (this.sender == targetPlayer) {
                this.message((MenuPlugin)plugin, this.sender, Message.DIALOG_OPEN_SUCCESS, "%name%", dialogName);
            } else {
                this.message((MenuPlugin)plugin, this.sender, Message.DIALOG_OPEN_SUCCESS_OTHER, "%name%", dialogName, "%player%", targetPlayer.getName());
            }
        }
        DialogInventory dialogInventory = optional.get();
        dialogManager.openDialog(targetPlayer, dialogInventory);
        return CommandType.SUCCESS;
    }
}

