/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands.dialogs;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.ConfigManagerInt;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandDialogOpenConfig
extends VCommand {
    public CommandDialogOpenConfig(ZMenuPlugin plugin) {
        super(plugin);
        this.addSubCommand("config");
        ConfigManagerInt configManager = plugin.getDialogManager().getConfigManager();
        this.addRequireArg("plugin name", (a, b) -> configManager.getRegisteredConfigs());
        this.addOptionalArg("player");
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        ConfigManagerInt configManager = plugin.getDialogManager().getConfigManager();
        String pluginName = this.argAsString(0);
        Player targetPlayer = this.argAsPlayer(1, this.player);
        if (targetPlayer == null) {
            this.message((MenuPlugin)plugin, this.sender, this.sender instanceof ConsoleCommandSender ? "\u00a7cYou must be a player to open a config gui." : "\u00a7cUnable to find the player.", new Object[0]);
            return CommandType.DEFAULT;
        }
        if (!configManager.getRegisteredConfigs().contains(pluginName)) {
            this.message((MenuPlugin)plugin, this.sender, "\u00a7cThe config '" + pluginName + "' does not exist.", new Object[0]);
            return CommandType.DEFAULT;
        }
        configManager.openConfig(pluginName, targetPlayer);
        return CommandType.SUCCESS;
    }
}

