/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.config;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.configuration.ConfigManagerInt;
import fr.maxlego08.menu.api.configuration.annotation.ConfigDialog;
import fr.maxlego08.menu.api.configuration.annotation.ConfigOption;
import fr.maxlego08.menu.api.configuration.annotation.ConfigUpdate;
import fr.maxlego08.menu.api.enums.DialogInputType;
import fr.maxlego08.menu.api.enums.DialogType;
import fr.maxlego08.menu.api.utils.dialogs.record.ZDialogInventoryBuild;
import fr.maxlego08.menu.config.ConfigFieldContext;
import fr.maxlego08.menu.config.processors.ConfigFieldProcessor;
import fr.maxlego08.menu.config.processors.ConfigFieldProcessorFactory;
import fr.maxlego08.menu.config.processors.ConfigFieldProcessorRegistry;
import fr.maxlego08.menu.hooks.ComponentMeta;
import fr.maxlego08.menu.hooks.dialogs.AbstractDialogManager;
import fr.maxlego08.menu.hooks.dialogs.ZDialogInventoryDeveloper;
import fr.maxlego08.menu.zcore.logger.Logger;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConfigManager
extends AbstractDialogManager
implements ConfigManagerInt {
    private final MenuPlugin menuPlugin;
    private final Map<String, ZDialogInventoryDeveloper> zDialogInventoryDev = new HashMap<String, ZDialogInventoryDeveloper>();
    private final ComponentMeta paperComponent;
    private final ConfigFieldProcessorRegistry processorRegistry;

    public ConfigManager(MenuPlugin menuPlugin) {
        super(menuPlugin);
        this.menuPlugin = menuPlugin;
        this.paperComponent = (ComponentMeta)menuPlugin.getMetaUpdater();
        this.processorRegistry = new ConfigFieldProcessorRegistry();
        this.initializeDefaultProcessors();
    }

    private void initializeDefaultProcessors() {
        ConfigFieldProcessorFactory factory = new ConfigFieldProcessorFactory();
        this.processorRegistry.registerProcessor(DialogInputType.BOOLEAN, factory.createBooleanProcessor());
        this.processorRegistry.registerProcessor(DialogInputType.NUMBER_RANGE, factory.createNumberRangeProcessor());
        this.processorRegistry.registerProcessor(DialogInputType.TEXT, factory.createTextProcessor());
    }

    @Override
    public <T> void registerConfig(Class<T> configClass, Plugin plugin) {
        ConfigDialog configDialog = this.validateConfigClass(configClass);
        String configName = plugin.getName() + ":" + configClass.getSimpleName();
        ConfigFieldContext context = this.processConfigFields(configClass);
        ZDialogInventoryDeveloper dialogInventory = this.createDialogInventory(configDialog, configName, context.getUpdateConsumer());
        this.applyContextToDialog(dialogInventory, context);
        this.zDialogInventoryDev.put(plugin.getName(), dialogInventory);
    }

    private <T> ConfigDialog validateConfigClass(Class<T> configClass) {
        ConfigDialog configDialog = configClass.getAnnotation(ConfigDialog.class);
        if (configDialog == null) {
            throw new IllegalArgumentException("The class " + configClass.getName() + " must be annotated with @ConfigDialog");
        }
        return configDialog;
    }

    private ZDialogInventoryDeveloper createDialogInventory(ConfigDialog configDialog, String configName, Consumer<Boolean> updateConsumer) {
        ZDialogInventoryDeveloper dialogInventory = new ZDialogInventoryDeveloper(this.menuPlugin, configDialog.name(), configName, configDialog.externalTitle(), updateConsumer);
        dialogInventory.setDialogType(DialogType.CONFIRMATION);
        dialogInventory.setBooleanConfirmText(configDialog.booleanConfirmText());
        dialogInventory.setNumberRangeConfirmText(configDialog.numberRangeConfirmText());
        dialogInventory.setStringConfirmText(configDialog.textConfirmText());
        dialogInventory.setYesText(configDialog.yesText());
        dialogInventory.setNoText(configDialog.noText());
        dialogInventory.setYesWidth(configDialog.yesWidth());
        dialogInventory.setNoWidth(configDialog.noWidth());
        dialogInventory.setPause(true);
        dialogInventory.setCanCloseWithEscape(false);
        return dialogInventory;
    }

    private <T> ConfigFieldContext processConfigFields(Class<T> configClass) {
        ConfigFieldContext context = new ConfigFieldContext();
        for (Field field : configClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(ConfigOption.class)) {
                this.processField(field, context);
                continue;
            }
            if (!field.isAnnotationPresent(ConfigUpdate.class)) continue;
            field.setAccessible(true);
            context.setUpdateConsumer(value -> {
                try {
                    field.setBoolean(null, (boolean)value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (context.getUpdateConsumer() == null) {
            Logger.info("No update consumer found for field " + configClass.getSimpleName() + ", this may be safe if you don't need to handle updates.", Logger.LogType.WARNING);
            context.setUpdateConsumer(value -> {});
        }
        return context;
    }

    private void processField(Field field, ConfigFieldContext context) {
        ConfigOption configOption = field.getAnnotation(ConfigOption.class);
        field.setAccessible(true);
        DialogInputType inputType = configOption.type();
        ConfigFieldProcessor processor = this.processorRegistry.getProcessor(inputType);
        if (processor != null) {
            processor.processField(field, configOption, context);
        } else {
            Logger.info("No processor found for input type: " + String.valueOf((Object)inputType), Logger.LogType.WARNING);
        }
    }

    private void applyContextToDialog(ZDialogInventoryDeveloper dialogInventory, ConfigFieldContext context) {
        dialogInventory.setConsumerMap(context.getBooleanConsumers());
        dialogInventory.setFloatConsumerMap(context.getFloatConsumers());
        dialogInventory.setIntegerConsumerMap(context.getIntegerConsumers());
        dialogInventory.setStringConsumerMap(context.getStringConsumers());
        dialogInventory.setInputButtons(context.getInputButtons());
    }

    @Override
    public void openConfig(Plugin plugin, Player player) {
        this.openConfig(plugin.getName(), player);
    }

    @Override
    public void openConfig(String pluginName, Player player) {
        block4: {
            try {
                ZDialogInventoryDeveloper zDialog = this.zDialogInventoryDev.get(pluginName);
                if (zDialog == null) {
                    if (Config.enableDebug) {
                        Logger.info("No dialog found for plugin: " + pluginName);
                    }
                    return;
                }
                ZDialogInventoryBuild dialogBuild = zDialog.getBuild(player);
                List<DialogInput> inputs = this.getDialogInputs(player, zDialog.getDialogInputs(player));
                DialogBase.Builder dialogBase = this.createDialogBase(dialogBuild.name(), dialogBuild.externalTitle(), dialogBuild.canCloseWithEscape(), zDialog.isPause(), zDialog.getAfterAction());
                Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).type((io.papermc.paper.registry.data.dialog.type.DialogType)io.papermc.paper.registry.data.dialog.type.DialogType.confirmation((ActionButton)ActionButton.create((Component)this.paperComponent.getComponent(zDialog.getYesText(player)), (Component)this.paperComponent.getComponent(zDialog.getYesTooltip(player)), (int)zDialog.getYesWidth(), (DialogAction)this.createAction(inputs, zDialog.getConsumerMap(), zDialog.getBooleanConfirmText(), zDialog.getFloatConsumerMap(), zDialog.getIntegerConsumerMap(), zDialog.getNumberRangeConfirmText(), zDialog.getStringConsumerMap(), zDialog.getStringConfirmText(), zDialog.getUpdateConsumer())), (ActionButton)ActionButton.create((Component)this.paperComponent.getComponent(zDialog.getNoText(player)), (Component)this.paperComponent.getComponent(zDialog.getNoTooltip(player)), (int)zDialog.getNoWidth(), (DialogAction)this.createAction(new ArrayList<DialogInput>(), new HashMap<String, Consumer<Boolean>>(), "", new HashMap<String, Consumer<Float>>(), new HashMap<String, Consumer<Integer>>(), "", new HashMap<String, Consumer<String>>(), "", null)))).base(dialogBase.inputs(inputs).build()));
                player.showDialog((DialogLike)dialog);
            }
            catch (Exception e) {
                if (!Config.enableDebug) break block4;
                Logger.info("Failed to open configuration dialog for player: " + player.getName() + " error :" + e.getMessage(), Logger.LogType.ERROR);
            }
        }
    }

    private DialogAction createAction(List<DialogInput> inputs, Map<String, Consumer<Boolean>> consumerMap, String booleanText, Map<String, Consumer<Float>> floatMap, Map<String, Consumer<Integer>> consumerMapInt, String numberRangeText, Map<String, Consumer<String>> stringMap, String stringText, Consumer<Boolean> updateConsumer) {
        return DialogAction.customClick((view, audience) -> {
            if (inputs.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder("Config Input Results:\n");
            for (DialogInput input : inputs) {
                String key = input.key();
                this.processInputResult(input, key, view, sb, consumerMap, booleanText, floatMap, consumerMapInt, numberRangeText, stringMap, stringText, updateConsumer);
            }
            this.getPaperComponent().sendMessage((CommandSender)((Player)audience), sb.toString());
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(-1).build()));
    }

    private void processInputResult(DialogInput input, String key, DialogResponseView view, StringBuilder sb, Map<String, Consumer<Boolean>> consumerMap, String booleanText, Map<String, Consumer<Float>> floatMap, Map<String, Consumer<Integer>> consumerMapInt, String numberRangeText, Map<String, Consumer<String>> stringMap, String stringText, Consumer<Boolean> updateConsumer) {
        DialogInput dialogInput = input;
        Objects.requireNonNull(dialogInput);
        DialogInput dialogInput2 = dialogInput;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumberRangeDialogInput.class, TextDialogInput.class, BooleanDialogInput.class}, (Object)dialogInput2, n)) {
            case 0: {
                NumberRangeDialogInput numberRangeDialogInput = (NumberRangeDialogInput)dialogInput2;
                this.processNumberRangeInput(key, view, sb, floatMap, consumerMapInt, numberRangeText, updateConsumer);
                break;
            }
            case 1: {
                TextDialogInput textDialogInput = (TextDialogInput)dialogInput2;
                this.processTextInput(key, view, sb, stringMap, stringText, updateConsumer);
                break;
            }
            case 2: {
                BooleanDialogInput booleanDialogInput = (BooleanDialogInput)dialogInput2;
                this.processBooleanInput(key, view, sb, consumerMap, booleanText, booleanDialogInput, updateConsumer);
                break;
            }
        }
    }

    private void processNumberRangeInput(String key, DialogResponseView view, StringBuilder sb, Map<String, Consumer<Float>> floatMap, Map<String, Consumer<Integer>> consumerMapInt, String numberRangeText, Consumer<Boolean> updateConsumer) {
        if (consumerMapInt.containsKey(key)) {
            int intValue = view.getFloat(key) == null ? 0 : (int)view.getFloat(key).floatValue();
            consumerMapInt.get(key).accept(intValue);
            this.executeUpdateConsumer(updateConsumer);
        } else if (floatMap.containsKey(key)) {
            float floatValue = view.getFloat(key).floatValue();
            floatMap.get(key).accept(Float.valueOf(floatValue));
            this.executeUpdateConsumer(updateConsumer);
        }
        String line = numberRangeText.replace("%key%", key).replace("%value%", String.valueOf(view.getFloat(key)));
        sb.append(line).append("\n");
    }

    private void processTextInput(String key, DialogResponseView view, StringBuilder sb, Map<String, Consumer<String>> stringMap, String stringText, Consumer<Boolean> updateConsumer) {
        String stringValue = view.getText(key);
        if (stringMap.containsKey(key)) {
            stringMap.get(key).accept(stringValue);
            this.executeUpdateConsumer(updateConsumer);
        }
        if (stringValue != null) {
            String line = stringText.replace("%key%", key).replace("%text%", stringValue);
            sb.append(line).append("\n");
        }
    }

    private void processBooleanInput(String key, DialogResponseView view, StringBuilder sb, Map<String, Consumer<Boolean>> consumerMap, String booleanText, BooleanDialogInput booleanDialogInput, Consumer<Boolean> updateConsumer) {
        Boolean booleanValue = view.getBoolean(key);
        if (booleanValue != null && consumerMap.containsKey(key)) {
            consumerMap.get(key).accept(booleanValue);
            this.executeUpdateConsumer(updateConsumer);
        }
        if (booleanValue != null) {
            String valueIcon = booleanValue != false ? "<green>\u2714<gray> |<red> \u274c" : "<red>\u2714<gray> |<green> \u274c";
            String text = booleanValue != false ? booleanDialogInput.onTrue() : booleanDialogInput.onFalse();
            String line = booleanText.replace("%key%", key).replace("%text%", text).replace("%value%", valueIcon);
            sb.append(line).append("\n");
        }
    }

    private void executeUpdateConsumer(Consumer<Boolean> updateConsumer) {
        if (updateConsumer != null) {
            updateConsumer.accept(true);
        }
    }

    @Override
    public List<String> getRegisteredConfigs() {
        return new ArrayList<String>(this.zDialogInventoryDev.keySet());
    }

    public ConfigFieldProcessorRegistry getProcessorRegistry() {
        return this.processorRegistry;
    }
}

