/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.LoreType;
import fr.maxlego08.menu.api.utils.MetaUpdater;
import fr.maxlego08.menu.api.utils.SimpleCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ComponentMeta
implements MetaUpdater {
    private static final Pattern LEGACY_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[0-9a-fA-F]){6}");
    private static final Pattern HEX_SHORT_PATTERN = Pattern.compile("(?<!<)(?<!:)&#([A-Fa-f0-9]{6})");
    private final MenuPlugin plugin;
    private final Component RESET = Component.empty().decoration(TextDecoration.ITALIC, false);
    private final MiniMessage MINI_MESSAGE = MiniMessage.builder().tags(TagResolver.builder().resolver(StandardTags.defaults()).build()).build();
    private final Map<String, String> COLORS_MAPPINGS = Map.ofEntries(Map.entry("0", "black"), Map.entry("1", "dark_blue"), Map.entry("2", "dark_green"), Map.entry("3", "dark_aqua"), Map.entry("4", "dark_red"), Map.entry("5", "dark_purple"), Map.entry("6", "gold"), Map.entry("7", "gray"), Map.entry("8", "dark_gray"), Map.entry("9", "blue"), Map.entry("a", "green"), Map.entry("b", "aqua"), Map.entry("c", "red"), Map.entry("d", "light_purple"), Map.entry("e", "yellow"), Map.entry("f", "white"), Map.entry("k", "obfuscated"), Map.entry("l", "bold"), Map.entry("m", "strikethrough"), Map.entry("n", "underlined"), Map.entry("o", "italic"), Map.entry("r", "reset"));
    private final SimpleCache<String, Component> cache = new SimpleCache();
    private final Method getLoreMethod;
    private final Method setLoreMethod;
    private final Method nameMethod;
    private final Method inventoryMethod;
    private final Method inventoryTypeMethod;

    public ComponentMeta(MenuPlugin plugin) throws Exception {
        this.plugin = plugin;
        this.getLoreMethod = ItemMeta.class.getDeclaredMethod("lore", new Class[0]);
        this.getLoreMethod.setAccessible(true);
        this.setLoreMethod = ItemMeta.class.getDeclaredMethod("lore", List.class);
        this.setLoreMethod.setAccessible(true);
        this.nameMethod = ItemMeta.class.getDeclaredMethod("displayName", Component.class);
        this.nameMethod.setAccessible(true);
        this.inventoryMethod = Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, Component.class);
        this.inventoryMethod.setAccessible(true);
        this.inventoryTypeMethod = Bukkit.class.getMethod("createInventory", InventoryHolder.class, InventoryType.class, Component.class);
        this.inventoryTypeMethod.setAccessible(true);
    }

    private TextDecoration.State getState(String text) {
        return text.contains("&o") || text.contains("<i>") || text.contains("<em>") || text.contains("<italic>") ? TextDecoration.State.TRUE : TextDecoration.State.FALSE;
    }

    public Component getComponent(String text) {
        return this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(text));
    }

    private void updateDisplayName(ItemMeta itemMeta, String text) {
        Component component = this.cache.get(text, () -> this.RESET.append(this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(text)).decoration(TextDecoration.ITALIC, this.getState(text))));
        try {
            this.nameMethod.invoke((Object)itemMeta, component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void updateDisplayName(ItemMeta itemMeta, String text, Player player) {
        this.updateDisplayName(itemMeta, text);
    }

    @Override
    public void updateDisplayName(ItemMeta itemMeta, String text, OfflinePlayer offlinePlayer) {
        this.updateDisplayName(itemMeta, text);
    }

    @Override
    public void updateLore(ItemMeta itemMeta, List<String> lore, Player player) {
        this.updateLore(itemMeta, lore, LoreType.REPLACE);
    }

    @Override
    public void updateLore(ItemMeta itemMeta, List<String> lore, OfflinePlayer offlinePlayer) {
        this.updateLore(itemMeta, lore, LoreType.REPLACE);
    }

    @Override
    public void updateLore(ItemMeta itemMeta, List<String> lore, LoreType loreType) {
        ArrayList<Object> components = new ArrayList<Object>(lore.size());
        for (String text : lore) {
            Component component = this.cache.get(text, () -> this.RESET.append(this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(text)).decoration(TextDecoration.ITALIC, this.getState(text))));
            components.add(component);
        }
        if (loreType != LoreType.REPLACE && itemMeta.hasLore()) {
            try {
                List currentLore = (List)this.getLoreMethod.invoke((Object)itemMeta, new Object[0]);
                if (currentLore != null) {
                    if (loreType == LoreType.APPEND) {
                        ArrayList cloneComponents = new ArrayList(components);
                        components.clear();
                        components.addAll(currentLore);
                        components.addAll(cloneComponents);
                    } else {
                        components.addAll(currentLore);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.setLoreMethod.invoke((Object)itemMeta, components);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Inventory createInventoryInternal(String inventoryName, InventoryHolder inventoryHolder, Object inventoryTypeOrSize) {
        Component component = this.cache.get(inventoryName, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(inventoryName)));
        try {
            if (inventoryTypeOrSize instanceof Integer) {
                return (Inventory)this.inventoryMethod.invoke(null, inventoryHolder, inventoryTypeOrSize, component);
            }
            if (inventoryTypeOrSize instanceof InventoryType) {
                return (Inventory)this.inventoryTypeMethod.invoke(null, inventoryHolder, inventoryTypeOrSize, component);
            }
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        if (inventoryTypeOrSize instanceof Integer) {
            return Bukkit.createInventory((InventoryHolder)inventoryHolder, (int)((Integer)inventoryTypeOrSize), (String)inventoryName);
        }
        return Bukkit.createInventory((InventoryHolder)inventoryHolder, (InventoryType)((InventoryType)inventoryTypeOrSize), (String)inventoryName);
    }

    @Override
    public Inventory createInventory(String inventoryName, int size, InventoryHolder inventoryHolder) {
        return this.createInventoryInternal(inventoryName, inventoryHolder, size);
    }

    @Override
    public Inventory createInventory(String inventoryName, InventoryType inventoryType, InventoryHolder inventoryHolder) {
        return this.createInventoryInternal(inventoryName, inventoryHolder, inventoryType);
    }

    private String colorMiniMessage(String message) {
        String newMessage = message;
        newMessage = this.convertLegacyHex(newMessage);
        newMessage = this.convertShorLegacyHex(newMessage);
        newMessage = newMessage.replaceAll("(?<![<&])(?<!:)#([A-Fa-f0-9]{6})", "<#$1>");
        newMessage = this.replaceLegacyColors(newMessage);
        return newMessage;
    }

    @Override
    public void sendMessage(CommandSender sender, String message) {
        if (sender != null) {
            Component component = this.cache.get(message, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(message)));
            sender.sendMessage(component);
        }
    }

    @Override
    public void sendAction(Player player, String message) {
        if (player != null) {
            Component component = this.cache.get(message, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(message)));
            player.sendActionBar(component);
        }
    }

    @Override
    public void sendTitle(Player player, String title, String subtitle, long start, long duration, long end) {
        if (player != null) {
            Title.Times times = Title.Times.times((Duration)Duration.ofMillis(start), (Duration)Duration.ofMillis(duration), (Duration)Duration.ofMillis(end));
            Component componentTitle = this.cache.get(title, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(title)));
            Component componentSubTitle = this.cache.get(subtitle, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(subtitle)));
            player.showTitle(Title.title((Component)componentTitle, (Component)componentSubTitle, (Title.Times)times));
        }
    }

    @Override
    public void openBook(Player player, String title, String author, List<String> lines) {
        Component titleComponent = this.cache.get(title, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(title)));
        Component authorComponent = this.cache.get(author, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(author)));
        ArrayList<Component> linesComponent = new ArrayList<Component>(lines.size());
        for (String text : lines) {
            String result = this.plugin.parse(player, text);
            Component component = this.cache.get(result, () -> this.MINI_MESSAGE.deserialize((Object)this.colorMiniMessage(result)));
            linesComponent.add(component);
        }
        Book book = Book.book((Component)titleComponent, (Component)authorComponent, linesComponent);
        if (player != null) {
            player.openBook(book);
        }
    }

    @NotNull
    private String convertLegacyHex(String message) {
        Matcher matcher = LEGACY_HEX_PATTERN.matcher(message);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String hex = matcher.group().replaceAll("\u00a7x|\u00a7", "");
            matcher.appendReplacement(sb, "<#" + hex + ">");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @NotNull
    private String convertShorLegacyHex(String message) {
        Matcher matcher = HEX_SHORT_PATTERN.matcher(message);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "<#" + matcher.group(1) + ">");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceLegacyColors(String message) {
        for (Map.Entry<String, String> entry : this.COLORS_MAPPINGS.entrySet()) {
            String key = entry.getKey();
            String value = "<" + entry.getValue() + ">";
            message = message.replace("&" + key, value).replace("\u00a7" + key, value).replace("&" + key.toUpperCase(), value).replace("\u00a7" + key.toUpperCase(), value);
        }
        return message;
    }
}

