/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies.providers;

import com.willfp.ecobits.currencies.Currencies;
import com.willfp.ecobits.currencies.Currency;
import com.willfp.ecobits.currencies.CurrencyUtils;
import fr.maxlego08.menu.hooks.currencies.CurrencyProvider;
import java.math.BigDecimal;
import org.bukkit.OfflinePlayer;

public class EcoBitProvider
implements CurrencyProvider {
    private Currency currency;
    private final String currencyName;

    public EcoBitProvider(String currencyName) {
        this.currencyName = currencyName;
    }

    private void initialize() {
        if (this.currency == null) {
            this.currency = Currencies.getByID((String)this.currencyName);
        }
    }

    @Override
    public void deposit(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        this.initialize();
        CurrencyUtils.adjustBalance((OfflinePlayer)offlinePlayer, (Currency)this.currency, (BigDecimal)amount);
    }

    @Override
    public void withdraw(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        this.initialize();
        CurrencyUtils.adjustBalance((OfflinePlayer)offlinePlayer, (Currency)this.currency, (BigDecimal)amount.negate());
    }

    @Override
    public BigDecimal getBalance(OfflinePlayer offlinePlayer) {
        this.initialize();
        return CurrencyUtils.getBalance((OfflinePlayer)offlinePlayer, (Currency)this.currency);
    }
}

