/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies.providers;

import fr.maxlego08.menu.hooks.currencies.CurrencyProvider;
import java.math.BigDecimal;
import me.qKing12.RoyaleEconomy.API.Currency;
import me.qKing12.RoyaleEconomy.API.MultiCurrencyHandler;
import org.bukkit.OfflinePlayer;

public class RoyaleEconomyProvider
implements CurrencyProvider {
    private Currency currency;
    private final String currencyId;

    public RoyaleEconomyProvider(String currencyId) {
        this.currencyId = currencyId;
    }

    private void initialize() {
        if (this.currency != null) {
            return;
        }
        if (MultiCurrencyHandler.getCurrencies() == null) {
            throw new NullPointerException("RoyaleEconomy multi-currency not enabled.");
        }
        this.currency = MultiCurrencyHandler.findCurrencyById((String)this.currencyId);
        if (this.currency == null) {
            throw new NullPointerException("RoyaleEconomy currency " + this.currencyId + " not found");
        }
    }

    @Override
    public void deposit(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        this.initialize();
        this.currency.addAmount(offlinePlayer.getUniqueId().toString(), amount.doubleValue());
    }

    @Override
    public void withdraw(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        this.initialize();
        this.currency.removeAmount(offlinePlayer.getUniqueId().toString(), amount.doubleValue());
    }

    @Override
    public BigDecimal getBalance(OfflinePlayer offlinePlayer) {
        this.initialize();
        return BigDecimal.valueOf(this.currency.getAmount(offlinePlayer.getUniqueId().toString()));
    }
}

