/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.dialogs;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.dialogs.InputButton;
import fr.maxlego08.menu.hooks.ComponentMeta;
import fr.maxlego08.menu.hooks.dialogs.loader.builder.DialogBuilderClass;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public abstract class AbstractDialogManager {
    protected final MenuPlugin menuPlugin;
    protected final ComponentMeta paperComponent;

    public AbstractDialogManager(MenuPlugin menuPlugin) {
        this.menuPlugin = menuPlugin;
        this.paperComponent = (ComponentMeta)menuPlugin.getMetaUpdater();
    }

    protected List<DialogInput> getDialogInputs(Player player, List<InputButton> inputButtons) {
        return this.buildDialogs(player, inputButtons, InputButton::getInputType, DialogBuilderClass::getDialogInputBuilder, (builder, button) -> builder.build(player, (InputButton)button));
    }

    protected <B, T, TYPE, BUILDER> List<T> buildDialogs(Player player, List<B> buttons, Function<B, TYPE> typeExtractor, Function<TYPE, Optional<BUILDER>> builderResolver, BiFunction<BUILDER, B, T> builderExecutor) {
        ArrayList<T> results = new ArrayList<T>(buttons.size());
        for (B button : buttons) {
            T value;
            Optional<BUILDER> builderOptional;
            TYPE type = typeExtractor.apply(button);
            if (type == null || !(builderOptional = builderResolver.apply(type)).isPresent() || (value = builderExecutor.apply(builderOptional.get(), button)) == null) continue;
            results.add(value);
        }
        return results;
    }

    protected DialogBase.Builder createDialogBase(String dialogName, String externalTitle, boolean canCloseWithEscape, boolean canPauseGame, String afterAction) {
        DialogBase.Builder dialogBuilder = DialogBase.builder((Component)this.toComponent(dialogName)).externalTitle(this.toComponent(externalTitle)).canCloseWithEscape(canCloseWithEscape).pause(canPauseGame).afterAction(DialogBase.DialogAfterAction.valueOf((String)afterAction));
        return dialogBuilder;
    }

    public ComponentMeta getPaperComponent() {
        return this.paperComponent;
    }

    public Component toComponent(String text) {
        return this.paperComponent.getComponent(text);
    }
}

