/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.dialogs;

import fr.maxlego08.menu.api.DialogInventory;
import fr.maxlego08.menu.api.DialogManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.dialogs.BodyButton;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.configuration.ConfigManagerInt;
import fr.maxlego08.menu.api.enums.DialogBodyType;
import fr.maxlego08.menu.api.enums.DialogType;
import fr.maxlego08.menu.api.exceptions.DialogException;
import fr.maxlego08.menu.api.exceptions.DialogFileNotFound;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.api.utils.dialogs.record.ActionButtonRecord;
import fr.maxlego08.menu.api.utils.dialogs.record.ZDialogInventoryBuild;
import fr.maxlego08.menu.hooks.ComponentMeta;
import fr.maxlego08.menu.hooks.dialogs.AbstractDialogManager;
import fr.maxlego08.menu.hooks.dialogs.ZDialogInventory;
import fr.maxlego08.menu.hooks.dialogs.loader.DialogLoader;
import fr.maxlego08.menu.hooks.dialogs.loader.builder.DialogBuilder;
import fr.maxlego08.menu.hooks.dialogs.loader.builder.DialogBuilderClass;
import fr.maxlego08.menu.zcore.logger.Logger;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ZDialogManager
extends AbstractDialogManager
implements DialogManager {
    private final MenuPlugin menuPlugin;
    private final ConfigManagerInt configManager;
    private static InventoryManager inventoryManager;
    private final Map<String, List<DialogInventory>> dialogs = new HashMap<String, List<DialogInventory>>();
    private final Map<UUID, DialogInventory> activeDialogs = new HashMap<UUID, DialogInventory>();
    private final DialogBuilderClass dialogBuilders;
    private final ComponentMeta paperComponent;

    public ZDialogManager(MenuPlugin menuPlugin, ConfigManagerInt configManager) {
        super(menuPlugin);
        this.menuPlugin = menuPlugin;
        this.configManager = configManager;
        this.paperComponent = (ComponentMeta)menuPlugin.getMetaUpdater();
        this.dialogBuilders = new DialogBuilderClass(this);
        inventoryManager = menuPlugin.getInventoryManager();
    }

    @Override
    public DialogInventory loadDialog(Plugin plugin, String fileName) throws DialogException {
        try {
            return this.loadInventory(plugin, fileName);
        }
        catch (InventoryException e) {
            throw new DialogException("Failed to load dialog: " + e.getMessage());
        }
    }

    @Override
    public Optional<DialogInventory> getDialog(String dialogName) {
        Optional<DialogInventory> dialogs;
        if (dialogName.contains(":")) {
            String[] values = dialogName.split(":", 2);
            dialogs = this.getDialog(values[0], values[1]);
        } else {
            dialogs = this.getDialogOptional(dialogName);
        }
        return dialogs;
    }

    public Optional<DialogInventory> getDialogOptional(String name) {
        for (List<DialogInventory> dialogList : this.dialogs.values()) {
            for (DialogInventory dialog : dialogList) {
                if (!dialog.getFileName().equals(name) && !dialog.getName(null).equals(name)) continue;
                return Optional.of(dialog);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<DialogInventory> getDialog(String pluginName, String fileName) {
        List<DialogInventory> pluginDialogs = this.dialogs.get(pluginName);
        if (pluginDialogs == null) {
            return Optional.empty();
        }
        for (DialogInventory dialog : pluginDialogs) {
            if (!dialog.getFileName().equals(fileName) && !dialog.getName(null).equals(fileName)) continue;
            return Optional.of(dialog);
        }
        return Optional.empty();
    }

    @Override
    public Optional<DialogInventory> getDialog(Plugin plugin, String fileName) {
        List<DialogInventory> pluginDialogs = this.dialogs.get(plugin.getName());
        if (pluginDialogs == null) {
            return Optional.empty();
        }
        for (DialogInventory dialog : pluginDialogs) {
            if (!dialog.getFileName().equals(fileName)) continue;
            return Optional.of(dialog);
        }
        return Optional.empty();
    }

    @Override
    public void deleteDialog(String name) {
        for (List<DialogInventory> dialogList : this.dialogs.values()) {
            dialogList.removeIf(dialog -> dialog.getFileName().equals(name) || dialog.getName(null).equals(name));
        }
    }

    @Override
    public void deleteDialog(Plugin plugin) {
        this.dialogs.remove(plugin.getName());
    }

    @Override
    public void loadDialogs() {
        File folder = new File(this.menuPlugin.getDataFolder(), "dialogs");
        if (!folder.exists()) {
            folder.mkdirs();
            return;
        }
        try (Stream<Path> stream = Files.walk(Paths.get(folder.getPath(), new String[0]), new FileVisitOption[0]);){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                File file = path.toFile();
                if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
                try {
                    this.loadInventory((Plugin)this.menuPlugin, file);
                }
                catch (DialogException | InventoryException exception) {
                    Logger.info("Failed to load dialog from file: " + file.getName(), Logger.LogType.WARNING);
                }
            }
        }
        catch (IOException exception) {
            Logger.info("Failed to load dialogs", Logger.LogType.WARNING);
        }
    }

    @Override
    public DialogInventory loadInventory(Plugin plugin, String fileName) throws DialogException, InventoryException {
        return this.loadInventory(plugin, fileName, ZDialogInventory.class);
    }

    @Override
    public DialogInventory loadInventory(Plugin plugin, File file) throws DialogException, InventoryException {
        return this.loadInventory(plugin, file, ZDialogInventory.class);
    }

    @Override
    public DialogInventory loadInventory(Plugin plugin, String fileName, Class<? extends DialogInventory> dialogClass) throws DialogException, InventoryException {
        File file = new File(plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            throw new DialogFileNotFound("Dialog file not found: " + fileName + " in " + plugin.getDataFolder().getAbsolutePath() + "/" + fileName);
        }
        return this.loadInventory(plugin, file, dialogClass);
    }

    @Override
    public DialogInventory loadInventory(Plugin plugin, File file, Class<? extends DialogInventory> dialogClass) throws DialogException, InventoryException {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        DialogLoader loader = new DialogLoader(this.menuPlugin, this);
        DialogInventory dialog = (DialogInventory)loader.load(configuration, "", file, dialogClass, plugin);
        List dialogsList = this.dialogs.computeIfAbsent(plugin.getName(), k -> new ArrayList());
        dialogsList.add(dialog);
        if (Config.enableInformationMessage) {
            Logger.info(file.getPath() + " loaded successfully!");
        }
        return dialog;
    }

    public void registerBuilder(DialogBuilder builder) {
        this.dialogBuilders.registerBuilder(builder);
    }

    @Override
    public void reloadDialogs() {
        this.dialogs.clear();
        this.activeDialogs.clear();
        this.loadDialogs();
        Logger.info("Dialogs reloaded successfully!");
    }

    @Override
    public void openDialog(Player player, DialogInventory zDialog) {
        block3: {
            try {
                boolean canOpen = zDialog.hasOpenRequirement(player);
                if (!canOpen) {
                    return;
                }
                ZDialogInventoryBuild dialogBuild = zDialog.getBuild(player);
                List<DialogBody> bodies = this.getDialogBodies(player, zDialog.getDialogBodies(player));
                List<DialogInput> inputs = this.getDialogInputs(player, zDialog.getDialogInputs(player));
                DialogBase.Builder dialogBase = this.createDialogBase(dialogBuild.name(), dialogBuild.externalTitle(), dialogBuild.canCloseWithEscape(), zDialog.isPause(), zDialog.getAfterAction());
                Dialog dialog = this.createDialogByType(zDialog.getDialogType(), dialogBase, bodies, inputs, zDialog, player);
                this.activeDialogs.put(player.getUniqueId(), zDialog);
                player.showDialog((DialogLike)dialog);
            }
            catch (Exception e) {
                if (!Config.enableInformationMessage) break block3;
                Logger.info("Failed to open dialog for player: " + player.getName() + " error :" + e.getMessage(), Logger.LogType.ERROR);
                if (!Config.enableDebug) break block3;
                Logger.info("Error details: " + String.valueOf(e), Logger.LogType.ERROR);
            }
        }
    }

    private Dialog createDialogByType(DialogType dialogType, DialogBase.Builder dialogBase, List<DialogBody> bodies, List<DialogInput> inputs, DialogInventory zDialog, Player player) {
        return switch (dialogType) {
            default -> throw new MatchException(null, null);
            case DialogType.NOTICE -> Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).type((io.papermc.paper.registry.data.dialog.type.DialogType)io.papermc.paper.registry.data.dialog.type.DialogType.notice((ActionButton)ActionButton.create((Component)this.paperComponent.getComponent(zDialog.getLabel(player)), (Component)this.paperComponent.getComponent(zDialog.getLabelTooltip(player)), (int)zDialog.getLabelWidth(), (DialogAction)this.createAction(inputs, zDialog.getActions())))).base(dialogBase.body(bodies).inputs(inputs).build()));
            case DialogType.CONFIRMATION -> Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).type((io.papermc.paper.registry.data.dialog.type.DialogType)io.papermc.paper.registry.data.dialog.type.DialogType.confirmation((ActionButton)ActionButton.create((Component)this.paperComponent.getComponent(zDialog.getYesText(player)), (Component)this.paperComponent.getComponent(zDialog.getYesTooltip(player)), (int)zDialog.getYesWidth(), (DialogAction)this.createAction(inputs, zDialog.getYesActions())), (ActionButton)ActionButton.create((Component)this.paperComponent.getComponent(zDialog.getNoText(player)), (Component)this.paperComponent.getComponent(zDialog.getNoTooltip(player)), (int)zDialog.getNoWidth(), (DialogAction)this.createAction(inputs, zDialog.getNoActions())))).base(dialogBase.body(bodies).inputs(inputs).build()));
            case DialogType.MULTI_ACTION -> Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).type((io.papermc.paper.registry.data.dialog.type.DialogType)io.papermc.paper.registry.data.dialog.type.DialogType.multiAction(this.createActionButtons(zDialog, inputs, zDialog.getActionButtons(player))).build()).base(dialogBase.body(bodies).inputs(inputs).build()));
            case DialogType.SERVER_LINKS -> Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).type((io.papermc.paper.registry.data.dialog.type.DialogType)io.papermc.paper.registry.data.dialog.type.DialogType.serverLinks((ActionButton)this.createActionButton(zDialog.getActionButtonServerLink(player), inputs), (int)zDialog.getNumberOfColumns(), (int)100)).base(dialogBase.body(bodies).inputs(inputs).build()));
        };
    }

    private List<ActionButton> createActionButtons(DialogInventory dialogInventory, List<DialogInput> inputs, List<ActionButtonRecord> actionButtonRecords) {
        if (dialogInventory == null) {
            return Collections.emptyList();
        }
        ArrayList<ActionButton> actionButtons = new ArrayList<ActionButton>();
        for (ActionButtonRecord actionButtonRecord : actionButtonRecords) {
            actionButtons.add(this.createActionButton(actionButtonRecord, inputs));
        }
        return actionButtons;
    }

    private ActionButton createActionButton(ActionButtonRecord actionButtonRecord, List<DialogInput> inputs) {
        return ActionButton.create((Component)this.paperComponent.getComponent(actionButtonRecord.label()), (Component)this.paperComponent.getComponent(actionButtonRecord.tooltip()), (int)actionButtonRecord.width(), (DialogAction)this.createAction(inputs, actionButtonRecord.actions()));
    }

    public DialogAction createAction(List<DialogInput> inputs, List<Requirement> requirements) {
        return DialogAction.customClick((view, audience) -> {
            Placeholders placeholders = new Placeholders();
            for (DialogInput input : inputs) {
                DialogInput selector0$temp;
                String key = input.key();
                String value = null;
                Objects.requireNonNull(input);
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumberRangeDialogInput.class, TextDialogInput.class, BooleanDialogInput.class, SingleOptionDialogInput.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        NumberRangeDialogInput numberRangeDialogInput = (NumberRangeDialogInput)selector0$temp;
                        Object rawValue = view.getFloat(key);
                        value = String.valueOf(rawValue);
                        break;
                    }
                    case 1: {
                        TextDialogInput textDialogInput = (TextDialogInput)selector0$temp;
                        Object rawValue = view.getText(key);
                        value = (String)rawValue;
                        break;
                    }
                    case 2: {
                        BooleanDialogInput booleanDialogInput = (BooleanDialogInput)selector0$temp;
                        Object rawValue = view.getBoolean(key);
                        value = String.valueOf(rawValue);
                        placeholders.register(key + "_text", (Boolean)rawValue != false ? booleanDialogInput.onTrue() : booleanDialogInput.onFalse());
                        break;
                    }
                    case 3: {
                        SingleOptionDialogInput singleOptionDialogInput = (SingleOptionDialogInput)selector0$temp;
                        Object rawValue = view.getText(key);
                        value = (String)rawValue;
                        break;
                    }
                }
                if (value == null) continue;
                placeholders.register(key, value);
            }
            for (Requirement requirement : requirements) {
                requirement.execute((Player)audience, null, inventoryManager.getFakeInventory(), placeholders);
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(-1).build()));
    }

    public Optional<DialogInventory> getActiveDialog(Player player) {
        return Optional.ofNullable(this.activeDialogs.get(player.getUniqueId()));
    }

    public void removeActiveDialog(Player player) {
        this.activeDialogs.remove(player.getUniqueId());
    }

    public boolean openDialogByName(Player player, String dialogName) {
        Optional<DialogInventory> dialog = this.getDialog(dialogName);
        if (dialog.isPresent()) {
            this.openDialog(player, dialog.get());
            return true;
        }
        return false;
    }

    @Override
    public Collection<DialogInventory> getDialogs() {
        ArrayList<DialogInventory> allDialogs = new ArrayList<DialogInventory>();
        for (List<DialogInventory> dialogList : this.dialogs.values()) {
            allDialogs.addAll(dialogList);
        }
        return Collections.unmodifiableCollection(allDialogs);
    }

    @Override
    public InventoryManager getInventoryManager() {
        return inventoryManager;
    }

    @Override
    public ConfigManagerInt getConfigManager() {
        return this.configManager;
    }

    public Optional<DialogBuilder> getDialogBuilder(DialogBodyType type) {
        return DialogBuilderClass.getDialogBuilder(type);
    }

    protected List<DialogBody> getDialogBodies(Player player, List<BodyButton> bodyButtons) {
        return this.buildDialogs(player, bodyButtons, BodyButton::getBodyType, DialogBuilderClass::getDialogBuilder, (builder, button) -> builder.build(player, (BodyButton)button));
    }
}

