/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.dialogs.loader.builder;

import fr.maxlego08.menu.api.button.dialogs.BodyButton;
import fr.maxlego08.menu.api.enums.DialogBodyType;
import fr.maxlego08.menu.hooks.dialogs.ZDialogManager;
import fr.maxlego08.menu.hooks.dialogs.loader.builder.DialogBuilder;
import fr.maxlego08.menu.hooks.dialogs.utils.BuilderHelper;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.entity.Player;

public class PlainMessageDialogBuilder
extends BuilderHelper
implements DialogBuilder {
    private final ZDialogManager dialogManager;

    public PlainMessageDialogBuilder(ZDialogManager dialogManager) {
        this.dialogManager = dialogManager;
    }

    @Override
    public DialogBodyType getBodyType() {
        return DialogBodyType.PLAIN_MESSAGE;
    }

    @Override
    public DialogBody build(Player player, BodyButton button) {
        List<String> messages = button.getMessages();
        if (messages.isEmpty()) {
            return null;
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (String message : messages) {
            String parsedMessage = this.papi(message, player);
            components.add(this.dialogManager.getPaperComponent().getComponent(parsedMessage));
        }
        Object finalComponent = components.size() == 1 ? (Component)components.getFirst() : Component.join((ComponentLike)Component.newline(), components);
        return DialogBody.plainMessage((Component)finalComponent, (int)button.getMessageWidth());
    }
}

