/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.mythicmobs;

import fr.maxlego08.menu.api.players.Data;
import fr.maxlego08.menu.api.players.DataManager;
import fr.maxlego08.menu.api.players.PlayerData;
import fr.maxlego08.menu.api.requirement.data.ActionPlayerDataType;
import fr.maxlego08.menu.api.storage.StorageManager;
import fr.maxlego08.menu.hooks.exp4j.ExpressionBuilder;
import fr.maxlego08.menu.players.ZData;
import fr.maxlego08.menu.zcore.logger.Logger;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DataMechanic
implements ITargetedEntitySkill {
    private final StorageManager storageManager;
    private final DataManager dataManager;
    private ActionPlayerDataType actionPlayerDataType;
    private final PlaceholderString key;
    private final PlaceholderString value;
    private final long seconds;
    private final boolean enableMathExpression;

    public DataMechanic(MythicLineConfig config, StorageManager storageManager, DataManager dataManager) {
        this.storageManager = storageManager;
        this.dataManager = dataManager;
        this.key = config.getPlaceholderString("key", "");
        this.value = config.getPlaceholderString("value", "");
        this.seconds = config.getLong(new String[]{"seconds"}, 0L);
        this.enableMathExpression = config.getBoolean(new String[]{"math"}, false);
        String action = config.getString(new String[]{"action"}, "set", new String[0]).toUpperCase();
        try {
            this.actionPlayerDataType = ActionPlayerDataType.valueOf(action);
        }
        catch (IllegalArgumentException e) {
            Logger.info("Invalid action type: " + action + " for a mechanic in MythicMobs, defaulting to SET");
            this.actionPlayerDataType = ActionPlayerDataType.SET;
        }
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        Entity player = BukkitAdapter.adapt((AbstractEntity)abstractEntity);
        if (player instanceof Player) {
            switch (this.actionPlayerDataType) {
                case REMOVE: {
                    Optional<PlayerData> optional = this.dataManager.getPlayer(player.getUniqueId());
                    optional.ifPresent(data -> data.removeData(this.key.get(abstractEntity)));
                    break;
                }
                case ADD: {
                    Optional<Data> optional = this.dataManager.getData(player.getUniqueId(), this.key.get(abstractEntity));
                    if (optional.isPresent()) {
                        Data data2 = optional.get();
                        String result = this.value.get(abstractEntity);
                        data2.add(this.enableMathExpression ? (int)new ExpressionBuilder(result).build().evaluate() : Integer.parseInt(result));
                        this.storageManager.upsertData(player.getUniqueId(), data2);
                        break;
                    }
                    this.dataManager.addData(player.getUniqueId(), this.toData(abstractEntity));
                    break;
                }
                case SUBTRACT: {
                    Optional<Data> optional = this.dataManager.getData(player.getUniqueId(), this.key.get(abstractEntity));
                    if (optional.isPresent()) {
                        Data data3 = optional.get();
                        String result = this.value.get(abstractEntity);
                        data3.remove(this.enableMathExpression ? (int)new ExpressionBuilder(result).build().evaluate() : Integer.parseInt(result));
                        this.storageManager.upsertData(player.getUniqueId(), data3);
                        break;
                    }
                    Data data4 = this.toData(abstractEntity);
                    data4.negate();
                    this.dataManager.addData(player.getUniqueId(), data4);
                    break;
                }
                case SET: {
                    this.dataManager.addData(player.getUniqueId(), this.toData(abstractEntity));
                }
            }
            return SkillResult.SUCCESS;
        }
        return SkillResult.ERROR;
    }

    private Data toData(AbstractEntity abstractEntity) {
        long expiredAt = this.seconds == 0L ? 0L : System.currentTimeMillis() + 1000L * this.seconds;
        String result = this.value.get(abstractEntity);
        String dataValue = this.enableMathExpression ? String.valueOf((int)new ExpressionBuilder(result).build().evaluate()) : result;
        return new ZData(this.key.get(abstractEntity), dataValue, expiredAt);
    }
}

