/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah;

import fr.maxlego08.menu.hooks.sarah.DatabaseConfiguration;
import fr.maxlego08.menu.hooks.sarah.DatabaseConnection;
import fr.maxlego08.menu.hooks.sarah.database.DatabaseType;
import fr.maxlego08.menu.hooks.sarah.libs.hikari.HikariConfig;
import fr.maxlego08.menu.hooks.sarah.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HikariDatabaseConnection
extends DatabaseConnection {
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
    private static final int MAXIMUM_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private static final int MINIMUM_IDLE = Math.min(MAXIMUM_POOL_SIZE, 10);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long LEAK_DETECTION_THRESHOLD = TimeUnit.SECONDS.toMillis(10L);
    private HikariDataSource dataSource;

    public HikariDatabaseConnection(DatabaseConfiguration databaseConfiguration) {
        super(databaseConfiguration);
        this.initializeDataSource();
    }

    private void initializeDataSource() {
        String jdbcUrl;
        HikariConfig config = new HikariConfig();
        config.setPoolName("sarah-" + POOL_COUNTER.getAndIncrement());
        DatabaseType databaseType = this.databaseConfiguration.getDatabaseType();
        if (databaseType == DatabaseType.MARIADB) {
            jdbcUrl = "jdbc:mariadb://" + this.databaseConfiguration.getHost() + ":" + this.databaseConfiguration.getPort() + "/" + this.databaseConfiguration.getDatabase() + "?allowMultiQueries=true";
            config.setDriverClassName("org.mariadb.jdbc.Driver");
        } else {
            jdbcUrl = "jdbc:mysql://" + this.databaseConfiguration.getHost() + ":" + this.databaseConfiguration.getPort() + "/" + this.databaseConfiguration.getDatabase() + "?allowMultiQueries=true";
            config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        }
        config.setJdbcUrl(jdbcUrl);
        config.setUsername(this.databaseConfiguration.getUser());
        config.setPassword(this.databaseConfiguration.getPassword());
        config.setMaximumPoolSize(MAXIMUM_POOL_SIZE);
        config.setMinimumIdle(MINIMUM_IDLE);
        config.setMaxLifetime(MAX_LIFETIME);
        config.setConnectionTimeout(CONNECTION_TIMEOUT);
        config.setLeakDetectionThreshold(LEAK_DETECTION_THRESHOLD);
        HashMap<String, String> commonProps = new HashMap<String, String>();
        commonProps.put("useSSL", "false");
        commonProps.put("useUnicode", "true");
        commonProps.put("characterEncoding", "utf8");
        commonProps.put("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
        if (databaseType == DatabaseType.MYSQL) {
            commonProps.put("cachePrepStmts", "true");
            commonProps.put("prepStmtCacheSize", "250");
            commonProps.put("prepStmtCacheSqlLimit", "2048");
            commonProps.put("useServerPrepStmts", "true");
            commonProps.put("useLocalSessionState", "true");
            commonProps.put("rewriteBatchedStatements", "true");
            commonProps.put("cacheResultSetMetadata", "true");
            commonProps.put("cacheServerConfiguration", "true");
            commonProps.put("elideSetAutoCommits", "true");
            commonProps.put("maintainTimeStats", "false");
            commonProps.put("alwaysSendSetIsolation", "false");
            commonProps.put("cacheCallableStmts", "true");
        }
        for (Map.Entry e : commonProps.entrySet()) {
            config.addDataSourceProperty((String)e.getKey(), e.getValue());
        }
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public Connection connectToDatabase() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    @Override
    public boolean isValid() {
        return this.dataSource != null && this.dataSource.isRunning();
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected boolean isConnected(Connection connection) {
        try {
            return connection != null && connection.isValid(1);
        }
        catch (SQLException exception) {
            return false;
        }
    }
}

