/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah.requests;

import fr.maxlego08.menu.hooks.sarah.DatabaseConfiguration;
import fr.maxlego08.menu.hooks.sarah.DatabaseConnection;
import fr.maxlego08.menu.hooks.sarah.conditions.ColumnDefinition;
import fr.maxlego08.menu.hooks.sarah.database.Executor;
import fr.maxlego08.menu.hooks.sarah.database.Schema;
import fr.maxlego08.menu.hooks.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InsertBatchRequest
implements Executor {
    private final List<Schema> schemas;

    public InsertBatchRequest(List<Schema> schemas) {
        this.schemas = schemas;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        if (this.schemas.isEmpty()) {
            return 0;
        }
        Schema firstSchema = this.schemas.get(0);
        StringBuilder insertQuery = new StringBuilder("INSERT INTO " + firstSchema.getTableName() + " (");
        StringBuilder valuesQuery = new StringBuilder("VALUES ");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDefinition column : firstSchema.getColumns()) {
            columnNames.add(column.getSafeName());
        }
        insertQuery.append(String.join((CharSequence)", ", columnNames)).append(") ");
        for (Schema schema : this.schemas) {
            ArrayList<String> rowPlaceholders = new ArrayList<String>();
            for (ColumnDefinition columnDefinition : schema.getColumns()) {
                rowPlaceholders.add("?");
                values.add(columnDefinition.getObject());
            }
            placeholders.add("(" + String.join((CharSequence)", ", rowPlaceholders) + ")");
        }
        valuesQuery.append(String.join((CharSequence)", ", placeholders));
        insertQuery.append((CharSequence)valuesQuery);
        String finalQuery = databaseConfiguration.replacePrefix(insertQuery.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block31: {
                ResultSet resultSet;
                int n2;
                PreparedStatement preparedStatement;
                block28: {
                    int n3;
                    block30: {
                        block29: {
                            preparedStatement = connection.prepareStatement(finalQuery, 1);
                            int index = 1;
                            for (Object e : values) {
                                preparedStatement.setObject(index++, e);
                            }
                            n2 = preparedStatement.executeUpdate();
                            resultSet = preparedStatement.getGeneratedKeys();
                            if (!resultSet.next()) break block28;
                            n3 = resultSet.getInt(1);
                            if (resultSet == null) break block29;
                            resultSet.close();
                        }
                        if (preparedStatement == null) break block30;
                        preparedStatement.close();
                    }
                    return n3;
                }
                try {
                    block32: {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block32;
                        {
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    n = n2;
                    if (preparedStatement == null) break block31;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

